package net.polyv.vclass.v1.entity.lesson;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询课节实时状态和在线人数响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询课节实时状态和在线人数响应实体")
public class VClassGetLessonLiveInfoResponse {
    
    /**
     * 课节ID
     */
    @ApiModelProperty(name = "lessonId", value = "课节ID", required = false)
    private Long lessonId;
    
    /**
     * 当前时间
     */
    @ApiModelProperty(name = "currentTime", value = "当前时间", required = false)
    @JSONField(name = "timestamp")
    private Date currentTime;
    
    /**
     * 课节内老师人数
     */
    @ApiModelProperty(name = "teacherOnlineCount", value = "课节内老师人数", required = false)
    private Long teacherOnlineCount;
    
    /**
     * 课节内学生人数
     */
    @ApiModelProperty(name = "studentOnlineCount", value = "课节内学生人数", required = false)
    private Long studentOnlineCount;
    
    /**
     * 课节状态 0：未开始 1：上课中 2：已下课 11：禁止上课
     */
    @ApiModelProperty(name = "status", value = "课节状态 0：未开始 1：上课中 2：已下课 11：禁止上课", required = false)
    private Integer status;
    
}