package net.polyv.vclass.v1.entity.lesson;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询课节回放视频响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询课节回放视频响应实体")
public class VClassGetPlaybackVideoResponse {
    
    /**
     * 课节ID
     */
    @ApiModelProperty(name = "lessonId", value = "课节ID", required = false)
    private Long lessonId;
    
    /**
     * 课节名称
     */
    @ApiModelProperty(name = "lessonName", value = "课节名称", required = false)
    private String lessonName;
    
    /**
     * 首屏截图
     */
    @ApiModelProperty(name = "firstImage", value = "首屏截图", required = false)
    private String firstImage;
    
    /**
     * 视频时长，格式 HH:mm:ss
     */
    @ApiModelProperty(name = "duration", value = "视频时长，格式 HH:mm:ss", required = false)
    private String duration;
    
    /**
     * 视频id
     */
    @ApiModelProperty(name = "vid", value = "视频id", required = false)
    private String vid;
    
    /**
     * 视频状态码 60/61：已发布 10：等待编码 20：正在编码 40：编码失败 50：等待审核 51：审核不通过
     */
    @ApiModelProperty(name = "status", value = "视频状态码 60/61：已发布 10：等待编码 20：正在编码 40：编码失败 50：等待审核 51：审核不通过", required =
            false)
    private Long status;
    
    /**
     * 视频创建时间
     */
    @ApiModelProperty(name = "createTime", value = "视频创建时间", required = false)
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    
    /**
     * 视频文件大小，单位：Bytes
     */
    @ApiModelProperty(name = "videoSize", value = "视频文件大小，单位：Bytes", required = false)
    private Long videoSize;
    
    /**
     * 播放次数
     */
    @ApiModelProperty(name = "playTimes", value = "播放次数", required = false)
    private Long playTimes;
    
    /**
     * 视频链接
     */
    @ApiModelProperty(name = "url", value = "视频链接", required = false)
    private String url;
    
}