package net.polyv.vclass.v1.entity.teach;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vclass.v1.entity.VClassCommonRequest;

/**
 * 讲师单点登录请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("讲师单点登录请求实体")
public class VClassTokenLoginRequest extends VClassCommonRequest {
    /**
     * 讲师Id（teacherId）
     */
    @ApiModelProperty(name = "teacherId", value = "讲师Id（teacherId）", required = true)
    @NotNull(message = "属性teacherId不能为空")
    private String teacherId;
    
    /**
     * 单点登录token，一次性有效，过期时间一个小时
     */
    @ApiModelProperty(name = "token", value = "单点登录token，一次性有效，过期时间一个小时", required = true)
    @NotNull(message = "属性token不能为空")
    private String token;
    
}