package net.polyv.vclass.v1.service.lesson.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.vclass.v1.config.VClassGlobalConfig;
import net.polyv.vclass.v1.constant.VClassURL;
import net.polyv.vclass.v1.entity.VClassCommonStatusResponse;
import net.polyv.vclass.v1.entity.lesson.VClassAddLessonRequest;
import net.polyv.vclass.v1.entity.lesson.VClassAddLessonResponse;
import net.polyv.vclass.v1.entity.lesson.VClassCutoffLessonRequest;
import net.polyv.vclass.v1.entity.lesson.VClassDeleteLessonRequest;
import net.polyv.vclass.v1.entity.lesson.VClassGetLessonInfoRequest;
import net.polyv.vclass.v1.entity.lesson.VClassGetLessonInfoResponse;
import net.polyv.vclass.v1.entity.lesson.VClassGetLessonLiveInfoRequest;
import net.polyv.vclass.v1.entity.lesson.VClassGetLessonLiveInfoResponse;
import net.polyv.vclass.v1.entity.lesson.VClassGetPlaybackVideoRequest;
import net.polyv.vclass.v1.entity.lesson.VClassGetPlaybackVideoResponse;
import net.polyv.vclass.v1.entity.lesson.VClassResumeLessonRequest;
import net.polyv.vclass.v1.entity.lesson.VClassUpdateLessonInfoRequest;
import net.polyv.vclass.v1.service.VClassBaseService;
import net.polyv.vclass.v1.service.lesson.VClassLessonService;

/**
 * 互动学堂课节管理
 * @author: jiangyifan
 */
public class VClassLessonServiceImpl extends VClassBaseService implements VClassLessonService {
    
    /**
     * 创建课节
     * API地址：https://help.polyv.net/#/vclass/api/lesson/add_lesson
     * @param vClassAddLessonRequest 创建课节请求实体
     * @return 创建课节响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public VClassAddLessonResponse addLesson(VClassAddLessonRequest vClassAddLessonRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_ADD_LESSON_URL;
        return this.postJsonBodyReturnOne(url, vClassAddLessonRequest, VClassAddLessonResponse.class);
    }
    
    /**
     * 获取课节信息
     * API地址：https://help.polyv.net/#/vclass/api/lesson/get_lesson
     * @param vClassGetLessonInfoRequest 获取课节信息请求实体
     * @return 获取课节信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public VClassGetLessonInfoResponse getLessonInfo(VClassGetLessonInfoRequest vClassGetLessonInfoRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_GET_LESSON_URL;
        return this.postJsonBodyReturnOne(url, vClassGetLessonInfoRequest, VClassGetLessonInfoResponse.class);
    }
    
    /**
     * 更新课节信息
     * API地址：https://help.polyv.net/#/vclass/api/lesson/update_lesson
     * @param vClassUpdateLessonInfoRequest 更新课节信息请求实体
     * @return 更新课节信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateLessonInfo(VClassUpdateLessonInfoRequest vClassUpdateLessonInfoRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_UPDATE_LESSON_URL;
        return this.postJsonBodyReturnOne(url, vClassUpdateLessonInfoRequest, VClassCommonStatusResponse.class)
                .getStatus();
    }
    
    /**
     * 删除课节
     * API地址：https://help.polyv.net/#/vclass/api/lesson/delete_lesson
     * @param vClassDeleteLessonRequest 删除课节请求实体
     * @return 删除课节响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteLesson(VClassDeleteLessonRequest vClassDeleteLessonRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_DELETE_LESSON_URL;
        return this.postJsonBodyReturnOne(url, vClassDeleteLessonRequest, VClassCommonStatusResponse.class).getStatus();
    }
    
    /**
     * 修改课节状态为禁止上课
     * API地址：https://help.polyv.net/#/vclass/api/lesson/cutoff
     * @param vClassCutoffLessonRequest 修改课节状态为禁止上课请求实体
     * @return 修改课节状态为禁止上课响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean cutoffLesson(VClassCutoffLessonRequest vClassCutoffLessonRequest)
            throws IOException, NoSuchAlgorithmException {
        vClassCutoffLessonRequest.setUserId(VClassGlobalConfig.getUserId());
        String url = VClassURL.getRealUrl(VClassURL.VCLASS_CUTOFF_LESSON_URL, vClassCutoffLessonRequest.getLessonId());
        return this.postFormBodyReturnOne(url, vClassCutoffLessonRequest, VClassCommonStatusResponse.class).getStatus();
    }
    
    /**
     * 恢复课节状态为可以上课
     * API地址：https://help.polyv.net/#/vclass/api/lesson/resume
     * @param vClassResumeLessonRequest 恢复课节状态为可以上课请求实体
     * @return 恢复课节状态为可以上课响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean resumeLesson(VClassResumeLessonRequest vClassResumeLessonRequest)
            throws IOException, NoSuchAlgorithmException {
        vClassResumeLessonRequest.setUserId(VClassGlobalConfig.getUserId());
        String url = VClassURL.getRealUrl(VClassURL.VCLASS_RESUME_LESSON_URL, vClassResumeLessonRequest.getLessonId());
        return this.postFormBodyReturnOne(url, vClassResumeLessonRequest, VClassCommonStatusResponse.class).getStatus();
    }
    
    /**
     * 查询课节实时状态和在线人数
     * API地址：https://help.polyv.net/#/vclass/api/lesson/get_lesson_live_info
     * @param vClassGetLessonLiveInfoRequest 查询课节实时状态和在线人数请求实体
     * @return 查询课节实时状态和在线人数响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<VClassGetLessonLiveInfoResponse> getLessonLiveInfo(
            VClassGetLessonLiveInfoRequest vClassGetLessonLiveInfoRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_GET_LESSON_LIVE_INFO_URL;
        return this.getReturnList(url, vClassGetLessonLiveInfoRequest, VClassGetLessonLiveInfoResponse.class);
        
    }
    
    /**
     * 查询课节回放视频
     * API地址：https://help.polyv.net/#/vclass/api/lesson/get_playback_video
     * @param vClassGetPlaybackVideoRequest 查询课节回放视频请求实体
     * @return 查询课节回放视频响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<VClassGetPlaybackVideoResponse> getPlaybackVideo(
            VClassGetPlaybackVideoRequest vClassGetPlaybackVideoRequest) throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_GET_LESSON_PLAYBACK_VIDEO_URL;
        return this.getReturnList(url, vClassGetPlaybackVideoRequest, VClassGetPlaybackVideoResponse.class);
    }
    
}
