/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs.model;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.util.List;
import net.raphimc.noteblocklib.format.nbs.NbsParser;
import net.raphimc.noteblocklib.model.Header;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.SongView;
import net.raphimc.noteblocklib.util.Instrument;

public class NbsHeader
implements Header {
    private short length;
    private byte version;
    private byte vanillaInstrumentCount;
    private short layerCount;
    private String title = "";
    private String author = "";
    private String originalAuthor = "";
    private String description = "";
    private short speed;
    private boolean autoSave;
    private byte autoSaveInterval;
    private byte timeSignature;
    private int minutesSpent;
    private int leftClicks;
    private int rightClicks;
    private int noteBlocksAdded;
    private int noteBlocksRemoved;
    private String sourceFileName = "";
    private boolean loop;
    private byte maxLoopCount;
    private short loopStartTick;

    public NbsHeader(LittleEndianDataInputStream dis) throws IOException {
        short length = dis.readShort();
        if (length == 0) {
            this.version = dis.readByte();
            this.vanillaInstrumentCount = dis.readByte();
            this.length = this.version >= 3 ? dis.readShort() : (short)-1;
        } else {
            this.length = length;
            this.version = 0;
            this.vanillaInstrumentCount = (byte)10;
        }
        if (this.version < 0 || this.version > 5) {
            throw new IllegalStateException("Unsupported NBS version: " + this.version);
        }
        this.layerCount = dis.readShort();
        this.title = NbsParser.readString(dis);
        this.author = NbsParser.readString(dis);
        this.originalAuthor = NbsParser.readString(dis);
        this.description = NbsParser.readString(dis);
        this.speed = dis.readShort();
        this.autoSave = dis.readBoolean();
        this.autoSaveInterval = dis.readByte();
        this.timeSignature = dis.readByte();
        this.minutesSpent = dis.readInt();
        this.leftClicks = dis.readInt();
        this.rightClicks = dis.readInt();
        this.noteBlocksAdded = dis.readInt();
        this.noteBlocksRemoved = dis.readInt();
        this.sourceFileName = NbsParser.readString(dis);
        if (this.version >= 4) {
            this.loop = dis.readBoolean();
            this.maxLoopCount = dis.readByte();
            this.loopStartTick = dis.readShort();
        }
    }

    public NbsHeader(short length, byte version, byte vanillaInstrumentCount, short layerCount, String title, String author, String originalAuthor, String description, short speed, boolean autoSave, byte autoSaveInterval, byte timeSignature, int minutesSpent, int leftClicks, int rightClicks, int noteBlocksAdded, int noteBlocksRemoved, String sourceFileName, boolean loop, byte maxLoopCount, short loopStartTick) {
        this(length, version, vanillaInstrumentCount, layerCount, title, author, originalAuthor, description, speed, autoSave, autoSaveInterval, timeSignature, minutesSpent, leftClicks, rightClicks, noteBlocksAdded, noteBlocksRemoved, sourceFileName);
        this.loop = loop;
        this.maxLoopCount = maxLoopCount;
        this.loopStartTick = loopStartTick;
    }

    public NbsHeader(short length, byte version, byte vanillaInstrumentCount, short layerCount, String title, String author, String originalAuthor, String description, short speed, boolean autoSave, byte autoSaveInterval, byte timeSignature, int minutesSpent, int leftClicks, int rightClicks, int noteBlocksAdded, int noteBlocksRemoved, String sourceFileName) {
        this.length = length;
        this.version = version;
        this.vanillaInstrumentCount = vanillaInstrumentCount;
        this.layerCount = layerCount;
        this.title = title;
        this.author = author;
        this.originalAuthor = originalAuthor;
        this.description = description;
        this.speed = speed;
        this.autoSave = autoSave;
        this.autoSaveInterval = autoSaveInterval;
        this.timeSignature = timeSignature;
        this.minutesSpent = minutesSpent;
        this.leftClicks = leftClicks;
        this.rightClicks = rightClicks;
        this.noteBlocksAdded = noteBlocksAdded;
        this.noteBlocksRemoved = noteBlocksRemoved;
        this.sourceFileName = sourceFileName;
    }

    public NbsHeader() {
    }

    public <N extends Note> NbsHeader(SongView<N> songView) {
        this.version = (byte)4;
        this.vanillaInstrumentCount = (byte)Instrument.values().length;
        this.title = songView.getTitle();
        this.length = (short)songView.getLength();
        this.speed = (short)(songView.getSpeed() * 100.0f);
        this.author = "NoteBlockLib";
        this.description = "Created with NoteBlockLib";
        this.layerCount = (short)songView.getNotes().values().stream().mapToInt(List::size).max().orElse(0);
    }

    public void write(LittleEndianDataOutputStream dos) throws IOException {
        if (this.version == 0) {
            dos.writeShort((int)this.length);
        } else {
            dos.writeShort(0);
            dos.writeByte((int)this.version);
            dos.writeByte((int)this.vanillaInstrumentCount);
            if (this.version >= 3) {
                dos.writeShort((int)this.length);
            }
        }
        dos.writeShort((int)this.layerCount);
        NbsParser.writeString(dos, this.title);
        NbsParser.writeString(dos, this.author);
        NbsParser.writeString(dos, this.originalAuthor);
        NbsParser.writeString(dos, this.description);
        dos.writeShort((int)this.speed);
        dos.writeBoolean(this.autoSave);
        dos.writeByte((int)this.autoSaveInterval);
        dos.writeByte((int)this.timeSignature);
        dos.writeInt(this.minutesSpent);
        dos.writeInt(this.leftClicks);
        dos.writeInt(this.rightClicks);
        dos.writeInt(this.noteBlocksAdded);
        dos.writeInt(this.noteBlocksRemoved);
        NbsParser.writeString(dos, this.sourceFileName);
        if (this.version >= 4) {
            dos.writeBoolean(this.loop);
            dos.writeByte((int)this.maxLoopCount);
            dos.writeShort((int)this.loopStartTick);
        }
    }

    public short getLength() {
        return this.length;
    }

    public void setLength(short length) {
        this.length = length;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    @Deprecated
    public byte getNbsVersion() {
        return this.version;
    }

    @Deprecated
    public void setNbsVersion(byte version) {
        this.version = version;
    }

    public byte getVanillaInstrumentCount() {
        return this.vanillaInstrumentCount;
    }

    public void setVanillaInstrumentCount(byte vanillaInstrumentCount) {
        this.vanillaInstrumentCount = vanillaInstrumentCount;
    }

    public short getLayerCount() {
        return this.layerCount;
    }

    public void setLayerCount(short layerCount) {
        this.layerCount = layerCount;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getOriginalAuthor() {
        return this.originalAuthor;
    }

    public void setOriginalAuthor(String originalAuthor) {
        this.originalAuthor = originalAuthor;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public short getSpeed() {
        return this.speed;
    }

    public void setSpeed(short speed) {
        this.speed = speed;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public byte getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public void setAutoSaveInterval(byte autoSaveInterval) {
        this.autoSaveInterval = autoSaveInterval;
    }

    public byte getTimeSignature() {
        return this.timeSignature;
    }

    public void setTimeSignature(byte timeSignature) {
        this.timeSignature = timeSignature;
    }

    public int getMinutesSpent() {
        return this.minutesSpent;
    }

    public void setMinutesSpent(int minutesSpent) {
        this.minutesSpent = minutesSpent;
    }

    public int getLeftClicks() {
        return this.leftClicks;
    }

    public void setLeftClicks(int leftClicks) {
        this.leftClicks = leftClicks;
    }

    public int getRightClicks() {
        return this.rightClicks;
    }

    public void setRightClicks(int rightClicks) {
        this.rightClicks = rightClicks;
    }

    public int getNoteBlocksAdded() {
        return this.noteBlocksAdded;
    }

    public void setNoteBlocksAdded(int noteBlocksAdded) {
        this.noteBlocksAdded = noteBlocksAdded;
    }

    public int getNoteBlocksRemoved() {
        return this.noteBlocksRemoved;
    }

    public void setNoteBlocksRemoved(int noteBlocksRemoved) {
        this.noteBlocksRemoved = noteBlocksRemoved;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public byte getMaxLoopCount() {
        return this.maxLoopCount;
    }

    public void setMaxLoopCount(byte maxLoopCount) {
        this.maxLoopCount = maxLoopCount;
    }

    public short getLoopStartTick() {
        return this.loopStartTick;
    }

    public void setLoopStartTick(short loopStartTick) {
        this.loopStartTick = loopStartTick;
    }
}

