/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.midi.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import net.raphimc.noteblocklib.format.midi.mapping.InstrumentMapping;
import net.raphimc.noteblocklib.format.midi.mapping.MidiMappings;
import net.raphimc.noteblocklib.format.midi.mapping.PercussionMapping;
import net.raphimc.noteblocklib.format.midi.model.MidiHeader;
import net.raphimc.noteblocklib.format.midi.model.MidiNote;
import net.raphimc.noteblocklib.model.NotemapData;

public class MidiData
extends NotemapData<MidiNote> {
    public MidiData(MidiHeader header, InputStream is) throws InvalidMidiDataException, IOException {
        if (header.getMidiFileFormat().getType() != 0 && header.getMidiFileFormat().getType() != 1) {
            throw new IllegalArgumentException("Midi file type must be 0 or 1");
        }
        if (header.getMidiFileFormat().getDivisionType() != 0.0f) {
            throw new IllegalArgumentException("Midi file division type must be PPQ");
        }
        Sequence sequence = MidiSystem.getSequence(is);
        ArrayList<TempoEvent> tempoEvents = new ArrayList<TempoEvent>();
        for (int trackIdx = 0; trackIdx < sequence.getTracks().length; ++trackIdx) {
            Track track = sequence.getTracks()[trackIdx];
            for (int eventIdx = 0; eventIdx < track.size(); ++eventIdx) {
                MetaMessage metaMessage;
                MidiEvent event = track.get(eventIdx);
                MidiMessage message = event.getMessage();
                if (!(message instanceof MetaMessage) || (metaMessage = (MetaMessage)message).getType() != 81 || metaMessage.getData().length != 3) continue;
                int newMpq = (metaMessage.getData()[0] & 0xFF) << 16 | (metaMessage.getData()[1] & 0xFF) << 8 | metaMessage.getData()[2] & 0xFF;
                tempoEvents.add(new TempoEvent(event.getTick(), (double)newMpq / (double)sequence.getResolution()));
            }
        }
        if (tempoEvents.isEmpty() || ((TempoEvent)tempoEvents.get(0)).getTick() != 0L) {
            tempoEvents.add(0, new TempoEvent(0L, 500000.0 / (double)sequence.getResolution()));
        }
        tempoEvents.sort(Comparator.comparingLong(TempoEvent::getTick));
        byte[] channelInstruments = new byte[16];
        byte[] channelVolumes = new byte[16];
        byte[] channelPans = new byte[16];
        Arrays.fill(channelVolumes, (byte)127);
        Arrays.fill(channelPans, (byte)64);
        for (int trackIdx = 0; trackIdx < sequence.getTracks().length; ++trackIdx) {
            Track track = sequence.getTracks()[trackIdx];
            double microTime = 0.0;
            long lastTick = 0L;
            double microsPerTick = ((TempoEvent)tempoEvents.get(0)).getMicrosPerTick();
            int tempoEventIdx = 1;
            for (int eventIdx = 0; eventIdx < track.size(); ++eventIdx) {
                MidiEvent event = track.get(eventIdx);
                MidiMessage message = event.getMessage();
                while (tempoEventIdx < tempoEvents.size() && event.getTick() > ((TempoEvent)tempoEvents.get(tempoEventIdx)).getTick()) {
                    TempoEvent tempoEvent = (TempoEvent)tempoEvents.get(tempoEventIdx++);
                    microTime += (double)(tempoEvent.getTick() - lastTick) * microsPerTick;
                    lastTick = tempoEvent.getTick();
                    microsPerTick = tempoEvent.getMicrosPerTick();
                }
                microTime += (double)(event.getTick() - lastTick) * microsPerTick;
                lastTick = event.getTick();
                if (!(message instanceof ShortMessage)) continue;
                ShortMessage shortMessage = (ShortMessage)message;
                if (shortMessage.getCommand() == 144) {
                    MidiNote note;
                    Object mapping;
                    byte instrument = channelInstruments[shortMessage.getChannel()];
                    byte key = (byte)shortMessage.getData1();
                    byte velocity = (byte)shortMessage.getData2();
                    byte effectiveVelocity = (byte)((float)velocity * (float)channelVolumes[shortMessage.getChannel()] / 127.0f);
                    byte pan = channelPans[shortMessage.getChannel()];
                    if (shortMessage.getChannel() == 9) {
                        mapping = MidiMappings.PERCUSSION_MAPPINGS.get(key);
                        if (mapping == null) continue;
                        note = new MidiNote(event.getTick(), ((PercussionMapping)mapping).getInstrument(), ((PercussionMapping)mapping).getKey(), effectiveVelocity, pan);
                    } else {
                        mapping = MidiMappings.INSTRUMENT_MAPPINGS.get(instrument);
                        if (mapping == null) continue;
                        int transposedKey = key - 21 + 12 * ((InstrumentMapping)mapping).getOctaveModifier();
                        byte clampedKey = (byte)Math.max(0, Math.min(transposedKey, 87));
                        note = new MidiNote(event.getTick(), ((InstrumentMapping)mapping).getInstrument(), clampedKey, effectiveVelocity, pan);
                    }
                    this.notes.computeIfAbsent((int)Math.round(microTime * 100.0 / 1000000.0), k -> new ArrayList()).add(note);
                    continue;
                }
                if (shortMessage.getCommand() == 192) {
                    channelInstruments[shortMessage.getChannel()] = (byte)shortMessage.getData1();
                    continue;
                }
                if (shortMessage.getCommand() == 176) {
                    if (shortMessage.getData1() == 7) {
                        channelVolumes[shortMessage.getChannel()] = (byte)shortMessage.getData2();
                        continue;
                    }
                    if (shortMessage.getData1() == 10) {
                        channelPans[shortMessage.getChannel()] = (byte)shortMessage.getData2();
                        continue;
                    }
                    if (shortMessage.getData1() != 121) continue;
                    channelVolumes[shortMessage.getChannel()] = 127;
                    channelPans[shortMessage.getChannel()] = 64;
                    continue;
                }
                if (shortMessage.getCommand() != 255) continue;
                Arrays.fill(channelInstruments, (byte)0);
                Arrays.fill(channelVolumes, (byte)127);
                Arrays.fill(channelPans, (byte)64);
            }
        }
    }

    public MidiData(Map<Integer, List<MidiNote>> notes) {
        super(notes);
    }

    private static class TempoEvent {
        private final long tick;
        private final double microsPerTick;

        public TempoEvent(long tick, double microsPerTick) {
            this.tick = tick;
            this.microsPerTick = microsPerTick;
        }

        public long getTick() {
            return this.tick;
        }

        public double getMicrosPerTick() {
            return this.microsPerTick;
        }
    }
}

