/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.player;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.raphimc.noteblocklib.model.SongView;
import net.raphimc.noteblocklib.player.SongPlayerCallback;

public class SongPlayer {
    private final SongView<?> songView;
    protected final SongPlayerCallback callback;
    private ScheduledExecutorService scheduler;
    private int tick;
    private boolean paused;

    public SongPlayer(SongView<?> songView, SongPlayerCallback callback) {
        this.songView = songView;
        this.callback = callback;
    }

    public SongView<?> getSongView() {
        return this.songView;
    }

    public boolean isRunning() {
        return this.scheduler != null && !this.scheduler.isTerminated();
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public void play() {
        this.paused = false;
        if (this.isRunning()) {
            this.stop();
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Song Player - " + this.songView.getTitle()).setDaemon(true).build());
        this.scheduler.scheduleAtFixedRate(this::tick, 0L, (long)(1.0E9 / (double)this.songView.getSpeed()), TimeUnit.NANOSECONDS);
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.scheduler.shutdownNow();
        try {
            this.scheduler.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.scheduler = null;
        this.tick = 0;
        this.paused = false;
    }

    protected void tick() {
        try {
            if (this.paused || !this.callback.shouldTick()) {
                return;
            }
            if (this.tick >= this.songView.getLength()) {
                if (this.callback.shouldLoop()) {
                    this.tick = -this.callback.getLoopDelay();
                } else {
                    this.callback.onFinished();
                    this.stop();
                    return;
                }
            }
            this.callback.playNotes(this.songView.getNotesAtTick(this.tick));
            ++this.tick;
        }
        catch (Throwable e) {
            if (e.getCause() instanceof InterruptedException) {
                return;
            }
            e.printStackTrace();
            this.stop();
        }
    }
}

