/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import com.hp.hpl.jena.sparql.syntax.ElementVisitorBase;
import com.hp.hpl.jena.sparql.syntax.ElementWalker;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.rootdev.javardfa.Parser;
import net.rootdev.javardfa.ParserFactory;
import net.rootdev.javardfa.QueryCollector;
import net.rootdev.javardfa.Setting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtilities {
    static final Logger log = LoggerFactory.getLogger(QueryUtilities.class);
    public static final QuerySolution NoResult = new QuerySolutionMap();

    public static Map<String, Query> makeQueries(ParserFactory.Format format, String source) throws SAXException, IOException {
        QueryCollector qc = new QueryCollector();
        XMLReader reader = ParserFactory.createReaderForFormat(qc, format);
        ((Parser)reader.getContentHandler()).enable(Setting.FormMode);
        if (source.matches("file:/[^/][^/].*")) {
            source = source.replaceFirst("file:/", "file:///");
        }
        reader.parse(source);
        return qc.getQueries();
    }

    public static QuerySolution extractBinding(Model model, Query query) {
        QuerySolution toReturn;
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet res = qe.execSelect();
        QuerySolution querySolution = toReturn = res.hasNext() ? res.next() : NoResult;
        if (res.hasNext()) {
            log.warn("More than one available binding");
        }
        qe.close();
        return toReturn;
    }

    public static Model bind(Query query, Map<String, String> bindings) {
        List<Triple> triples = QueryUtilities.pullTriples(query);
        LinkedList boundTriples = new LinkedList();
        Model model = ModelFactory.createDefaultModel();
        for (Triple t : triples) {
            Node s = QueryUtilities.bind(t.getSubject(), bindings);
            Node p = QueryUtilities.bind(t.getPredicate(), bindings);
            Node o = QueryUtilities.bind(t.getObject(), bindings);
            Triple nt = Triple.create((Node)s, (Node)p, (Node)o);
            model.add(model.asStatement(nt));
        }
        return model;
    }

    private static List<Triple> pullTriples(Query query) {
        LinkedList<Triple> triples = new LinkedList<Triple>();
        ElementWalker.walk((Element)query.getQueryPattern(), (ElementVisitor)new TripleCollector(triples));
        return triples;
    }

    private static Node bind(Node object, Map<String, String> bindings) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TripleCollector
    extends ElementVisitorBase {
        private final List<Triple> triples;

        private TripleCollector(List<Triple> triples) {
            this.triples = triples;
        }

        public void visit(ElementTriplesBlock el) {
            this.triples.addAll(el.getPattern().getList());
        }
    }
}

