/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick;

import java.util.ArrayList;
import java.util.List;
import org.amplecode.quick.StatementManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;

public class StatementInterceptor {
    private static final Log log = LogFactory.getLog(StatementInterceptor.class);
    private List<StatementManager> statementManagers = new ArrayList<StatementManager>();

    public void setStatementManagers(List<StatementManager> statementManagers) {
        this.statementManagers = statementManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object = null;
        for (StatementManager manager : this.statementManagers) {
            manager.initialise();
            log.debug((Object)"Initialised statement manager");
        }
        try {
            object = joinPoint.proceed();
        }
        finally {
            for (StatementManager manager : this.statementManagers) {
                try {
                    manager.destroy();
                    log.debug((Object)"Destroyed statement manager");
                }
                catch (Exception ex) {
                    log.warn((Object)"Failed to destroy statement manager", (Throwable)ex);
                }
            }
        }
        return object;
    }
}

