/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.factory;

import java.lang.reflect.Constructor;
import org.amplecode.quick.BatchHandler;
import org.amplecode.quick.BatchHandlerFactory;
import org.amplecode.quick.JdbcConfiguration;
import org.amplecode.quick.statement.JdbcStatementManager;

public class DefaultBatchHandlerFactory
implements BatchHandlerFactory {
    private JdbcConfiguration jdbcConfiguration;
    private boolean inMemory = false;

    public void setJdbcConfiguration(JdbcConfiguration jdbcConfiguration) {
        this.jdbcConfiguration = jdbcConfiguration;
    }

    public void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    @Override
    public <T> BatchHandler<T> createBatchHandler(Class<? extends BatchHandler<T>> clazz) {
        return this.createBatchHandler(clazz, this.inMemory ? JdbcStatementManager.IN_MEMORY_JDBC_CONFIG : this.jdbcConfiguration);
    }

    private <T> BatchHandler<T> createBatchHandler(Class<? extends BatchHandler<T>> clazz, JdbcConfiguration config) {
        try {
            Class[] argumentClasses = new Class[]{JdbcConfiguration.class};
            Constructor<BatchHandler<T>> constructor = clazz.getConstructor(argumentClasses);
            Object[] arguments = new Object[]{config};
            BatchHandler<T> batchHandler = constructor.newInstance(arguments);
            return batchHandler;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get BatchHandler", ex);
        }
    }
}

