/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.factory;

import org.amplecode.quick.StatementBuilder;
import org.amplecode.quick.StatementDialect;
import org.amplecode.quick.statementbuilder.DerbyStatementBuilder;
import org.amplecode.quick.statementbuilder.H2StatementBuilder;
import org.amplecode.quick.statementbuilder.HsqlStatementBuilder;
import org.amplecode.quick.statementbuilder.MySqlStatementBuilder;
import org.amplecode.quick.statementbuilder.PostgreSqlStatementBuilder;

public class StatementBuilderFactory {
    public static StatementBuilder createStatementBuilder(StatementDialect dialect) {
        if (dialect.equals((Object)StatementDialect.MYSQL)) {
            return new MySqlStatementBuilder();
        }
        if (dialect.equals((Object)StatementDialect.POSTGRESQL)) {
            return new PostgreSqlStatementBuilder();
        }
        if (dialect.equals((Object)StatementDialect.H2)) {
            return new H2StatementBuilder();
        }
        if (dialect.equals((Object)StatementDialect.HSQL)) {
            return new HsqlStatementBuilder();
        }
        if (dialect.equals((Object)StatementDialect.DERBY)) {
            return new DerbyStatementBuilder();
        }
        throw new RuntimeException("Unsupported dialect: " + (Object)((Object)dialect));
    }
}

