/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.statement;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.amplecode.quick.StatementHolder;

public class DefaultStatementHolder
implements StatementHolder {
    private Connection connection;
    private boolean pooled;
    private Statement statement;

    public DefaultStatementHolder(Connection connection) {
        this.connection = connection;
    }

    public DefaultStatementHolder(Connection connection, boolean pooled) {
        this.connection = connection;
        this.pooled = pooled;
        this.statement = this.createStatement();
    }

    @Override
    public Statement getStatement() {
        return this.statement != null ? this.statement : this.createStatement();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isPooled() {
        return this.pooled;
    }

    @Override
    public int executeUpdate(String sql) {
        return this.executeUpdate(sql, false);
    }

    @Override
    public int executeUpdate(String sql, boolean ignoreException) {
        try {
            int n = this.statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            if (!ignoreException) {
                this.forceClose();
            }
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public Integer queryForInteger(String sql) {
        try {
            ResultSet resultSet = this.statement.executeQuery(sql);
            Integer n = resultSet.next() ? Integer.valueOf(resultSet.getInt(1)) : null;
            return n;
        }
        catch (SQLException ex) {
            this.forceClose();
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public Double queryForDouble(String sql) {
        try {
            ResultSet resultSet = this.statement.executeQuery(sql);
            Double d = resultSet.next() ? Double.valueOf(resultSet.getDouble(1)) : null;
            return d;
        }
        catch (SQLException ex) {
            this.forceClose();
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public String queryForString(String sql) {
        try {
            ResultSet resultSet = this.statement.executeQuery(sql);
            String string = resultSet.next() ? resultSet.getString(1) : null;
            return string;
        }
        catch (SQLException ex) {
            this.forceClose();
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public int update(String sql) {
        try {
            int n = this.statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            this.forceClose();
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (!this.pooled) {
            this.forceClose();
        }
    }

    @Override
    public void forceClose() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private Statement createStatement() {
        try {
            return this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.forceClose();
            throw new RuntimeException("Failed to create statement", ex);
        }
    }
}

