/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.statement;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.amplecode.quick.JdbcConfiguration;
import org.amplecode.quick.StatementDialect;
import org.amplecode.quick.StatementHolder;
import org.amplecode.quick.StatementManager;
import org.amplecode.quick.statement.DefaultStatementHolder;

public class JdbcStatementManager
implements StatementManager {
    public static final JdbcConfiguration IN_MEMORY_JDBC_CONFIG = new JdbcConfiguration(StatementDialect.HSQL, "org.hsqldb.jdbc.JDBCDriver", "jdbc:hsqldb:mem:quick", "SA", "");
    private ThreadLocal<StatementHolder> holderTag = new ThreadLocal();
    private JdbcConfiguration jdbcConfiguration;
    private boolean inMemory = false;

    public void setJdbcConfiguration(JdbcConfiguration jdbcConfiguration) {
        this.jdbcConfiguration = jdbcConfiguration;
    }

    public void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    @Override
    public void initialise() {
        Connection connection = this.getConnection();
        DefaultStatementHolder holder = new DefaultStatementHolder(connection, true);
        this.holderTag.set(holder);
    }

    @Override
    public StatementHolder getHolder() {
        StatementHolder holder = this.holderTag.get();
        if (holder != null) {
            return holder;
        }
        return new DefaultStatementHolder(this.getConnection(), false);
    }

    @Override
    public StatementHolder getHolder(boolean autoCommit) {
        try {
            Connection connection = this.getConnection();
            connection.setAutoCommit(autoCommit);
            return new DefaultStatementHolder(connection);
        }
        catch (SQLException ex) {
            this.destroy();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void destroy() {
        StatementHolder holder = this.holderTag.get();
        if (holder != null) {
            holder.forceClose();
            this.holderTag.remove();
        }
    }

    @Override
    public JdbcConfiguration getConfiguration() {
        return this.inMemory ? IN_MEMORY_JDBC_CONFIG : this.jdbcConfiguration;
    }

    private Connection getConnection() {
        return this.getConnection(this.getConfiguration());
    }

    private Connection getConnection(JdbcConfiguration config) {
        try {
            Class.forName(config.getDriverClass());
            Connection connection = DriverManager.getConnection(config.getConnectionUrl(), config.getUsername(), config.getPassword());
            return connection;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create connection", ex);
        }
    }
}

