/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.FragmentArg;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.holder.EFragmentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class FragmentArgHandler
extends BaseAnnotationHandler<EFragmentHolder> {
    private final AnnotationHelper annotationHelper;
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public FragmentArgHandler(ProcessingEnvironment processingEnvironment) {
        super(FragmentArg.class, processingEnvironment);
        this.annotationHelper = new AnnotationHelper(this.processingEnv);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEFragment(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EFragmentHolder holder) {
        FragmentArg annotation = element.getAnnotation(FragmentArg.class);
        String argKey = annotation.value();
        String fieldName = element.getSimpleName().toString();
        if (argKey.isEmpty()) {
            argKey = fieldName;
        }
        BundleHelper bundleHelper = new BundleHelper(this.annotationHelper, element);
        JFieldVar argKeyStaticField = this.createStaticArgField(holder, argKey, fieldName);
        this.injectArgInComponent(element, holder, bundleHelper, argKeyStaticField, fieldName);
        this.createBuilderInjectionMethod(element, holder, bundleHelper, argKeyStaticField, fieldName);
    }

    private JFieldVar createStaticArgField(EFragmentHolder holder, String argKey, String fieldName) {
        String staticFieldName = fieldName.endsWith("Arg") ? CaseHelper.camelCaseToUpperSnakeCase(fieldName) : CaseHelper.camelCaseToUpperSnakeCase(fieldName + "Arg");
        return holder.getGeneratedClass().field(25, this.classes().STRING, staticFieldName, JExpr.lit(argKey));
    }

    private void injectArgInComponent(Element element, EFragmentHolder holder, BundleHelper bundleHelper, JFieldVar extraKeyStaticField, String fieldName) {
        JVar bundle = holder.getInjectBundleArgs();
        JBlock injectExtrasBlock = holder.getInjectArgsBlock();
        JFieldRef extraField = JExpr.ref(fieldName);
        JBlock ifContainsKey = injectExtrasBlock._if(JExpr.invoke((JExpression)bundle, "containsKey").arg(extraKeyStaticField))._then();
        JExpressionImpl restoreMethodCall = JExpr.invoke((JExpression)bundle, bundleHelper.getMethodNameToRestore()).arg(extraKeyStaticField);
        if (bundleHelper.restoreCallNeedCastStatement()) {
            JMethod injectExtrasMethod;
            JClass jclass = this.codeModelHelper.typeMirrorToJClass(element.asType(), holder);
            restoreMethodCall = JExpr.cast(jclass, restoreMethodCall);
            if (bundleHelper.restoreCallNeedsSuppressWarning() && (injectExtrasMethod = holder.getInjectArgsMethod()).annotations().size() == 0) {
                injectExtrasMethod.annotate(SuppressWarnings.class).param("value", "unchecked");
            }
        }
        ifContainsKey.assign(extraField, restoreMethodCall);
    }

    private void createBuilderInjectionMethod(Element element, EFragmentHolder holder, BundleHelper bundleHelper, JFieldVar argKeyStaticField, String fieldName) {
        JDefinedClass builderClass = holder.getBuilderClass();
        JFieldRef builderArgsField = holder.getBuilderArgsField();
        TypeMirror elementType = element.asType();
        JClass paramClass = this.codeModelHelper.typeMirrorToJClass(elementType, holder);
        JMethod method = builderClass.method(1, builderClass, fieldName);
        JVar arg = method.param(paramClass, fieldName);
        method.body().invoke((JExpression)builderArgsField, bundleHelper.getMethodNameToSave()).arg(argKeyStaticField).arg(arg);
        method.body()._return(JExpr._this());
    }
}

