/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.androidannotations.helper.AnnotationHelper;

public class GreenDroidHelper {
    public static final String GREENDROID_GD_ACTIVITY_CLASS = "greendroid.app.GDActivity";
    public static final String GREENDROID_GD_LIST_ACTIVITY_CLASS = "greendroid.app.GDListActivity";
    public static final String GREENDROID_GD_TAB_ACTIVITY_CLASS = "greendroid.app.GDTabActivity";
    public static final String GREENDROID_GD_MAP_ACTIVITY_CLASS = "greendroid.app.GDMapActivity";
    public static final List<String> GREENDROID_ACTIVITIES_LIST_CLASS = Arrays.asList("greendroid.app.GDActivity", "greendroid.app.GDListActivity", "greendroid.app.GDTabActivity", "greendroid.app.GDMapActivity");
    private ProcessingEnvironment processingEnv;
    private List<TypeElement> greendroidActivityElements;

    public GreenDroidHelper(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        AnnotationHelper annotationHelper = new AnnotationHelper(processingEnv);
        this.greendroidActivityElements = new ArrayList<TypeElement>();
        for (String greendroidActivityName : GREENDROID_ACTIVITIES_LIST_CLASS) {
            TypeElement typeElement = annotationHelper.typeElementFromQualifiedName(greendroidActivityName);
            if (typeElement == null) continue;
            this.greendroidActivityElements.add(typeElement);
        }
    }

    public boolean usesGreenDroid(TypeElement annotatedElement) {
        for (TypeElement greendroidActivityElement : this.greendroidActivityElements) {
            if (!this.processingEnv.getTypeUtils().isSubtype(annotatedElement.asType(), greendroidActivityElement.asType())) continue;
            return true;
        }
        return false;
    }
}

