/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import org.androidannotations.api.sharedpreferences.AbstractPrefField;

public final class IntPrefField
extends AbstractPrefField {
    private final int defaultValue;

    IntPrefField(SharedPreferences sharedPreferences, String key, int defaultValue) {
        super(sharedPreferences, key);
        this.defaultValue = defaultValue;
    }

    public int get() {
        return this.getOr(this.defaultValue);
    }

    public int getOr(int defaultValue) {
        try {
            return this.sharedPreferences.getInt(this.key, defaultValue);
        }
        catch (ClassCastException e) {
            try {
                String value = this.sharedPreferences.getString(this.key, "" + defaultValue);
                return Integer.parseInt(value);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public void put(int value) {
        this.apply(this.edit().putInt(this.key, value));
    }
}

