/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.ItemClick;
import org.androidannotations.handler.AbstractListenerHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ItemClickHandler
extends AbstractListenerHandler {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public ItemClickHandler(ProcessingEnvironment processingEnvironment) {
        super(ItemClick.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.validatorHelper.param.zeroOrOneParameter(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        listenerMethodBody.add(call);
    }

    @Override
    protected void processParameters(EComponentWithViewSupportHolder holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        boolean hasItemParameter = parameters.size() == 1;
        JClass narrowAdapterViewClass = this.classes().ADAPTER_VIEW.narrow(this.codeModel().wildcard());
        JVar onItemClickParentParam = listenerMethod.param(narrowAdapterViewClass, "parent");
        listenerMethod.param(this.classes().VIEW, "view");
        JVar onItemClickPositionParam = listenerMethod.param(this.codeModel().INT, "position");
        listenerMethod.param(this.codeModel().LONG, "id");
        if (hasItemParameter) {
            VariableElement parameter = parameters.get(0);
            TypeMirror parameterType = parameter.asType();
            if (parameterType.getKind() == TypeKind.INT) {
                call.arg(onItemClickPositionParam);
            } else {
                JClass parameterClass = this.codeModelHelper.typeMirrorToJClass(parameterType, this.getHolder());
                call.arg(JExpr.cast(parameterClass, JExpr.invoke((JExpression)onItemClickParentParam, "getAdapter").invoke("getItem").arg(onItemClickPositionParam)));
                if (parameterClass.isParameterized()) {
                    listenerMethod.annotate(SuppressWarnings.class).param("value", "unchecked");
                }
            }
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, this.codeModel().VOID, "onItemClick");
    }

    @Override
    protected String getSetterName() {
        return "setOnItemClickListener";
    }

    @Override
    protected JClass getListenerClass() {
        return this.classes().ON_ITEM_CLICK_LISTENER;
    }

    @Override
    protected JClass getViewClass() {
        return this.classes().ADAPTER_VIEW.narrow(this.codeModel().wildcard());
    }
}

