/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JGenerifiable;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import javax.lang.model.element.TypeElement;
import org.androidannotations.api.builder.FragmentBuilder;
import org.androidannotations.helper.ActionBarSherlockHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.HasInstanceState;
import org.androidannotations.holder.HasOnActivityResult;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.holder.HasReceiverRegistration;
import org.androidannotations.holder.InstanceStateHolder;
import org.androidannotations.holder.OnActivityResultHolder;
import org.androidannotations.holder.ReceiverRegistrationHolder;
import org.androidannotations.process.ProcessHolder;

public class EFragmentHolder
extends EComponentWithViewSupportHolder
implements HasInstanceState,
HasOptionsMenu,
HasOnActivityResult,
HasReceiverRegistration {
    private JFieldVar contentView;
    private JBlock setContentViewBlock;
    private JVar inflater;
    private JVar container;
    private JDefinedClass fragmentBuilderClass;
    private JClass narrowBuilderClass;
    private JFieldRef fragmentArgumentsBuilderField;
    private JMethod injectArgsMethod;
    private JBlock injectArgsBlock;
    private JVar injectBundleArgs;
    private InstanceStateHolder instanceStateHolder = new InstanceStateHolder(this);
    private OnActivityResultHolder onActivityResultHolder = new OnActivityResultHolder(this);
    private ReceiverRegistrationHolder receiverRegistrationHolder = new ReceiverRegistrationHolder(this);
    private JBlock onCreateOptionsMenuMethodBody;
    private JVar onCreateOptionsMenuMenuInflaterVar;
    private JVar onCreateOptionsMenuMenuParam;
    private JVar onOptionsItemSelectedItem;
    private JVar onOptionsItemSelectedItemId;
    private JBlock onOptionsItemSelectedIfElseBlock;
    private JBlock onCreateAfterSuperBlock;
    private JBlock onDestroyBeforeSuperBlock;
    private JBlock onStartAfterSuperBlock;
    private JBlock onStopBeforeSuperBlock;
    private JBlock onResumeAfterSuperBlock;
    private JBlock onPauseBeforeSuperBlock;
    private JBlock onAttachAfterSuperBlock;
    private JBlock onDetachBeforeSuperBlock;

    public EFragmentHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        super(processHolder, annotatedElement);
        this.setOnCreate();
        this.setOnViewCreated();
        this.setFragmentBuilder();
    }

    private void setOnCreate() {
        JMethod onCreate = this.generatedClass.method(1, this.codeModel().VOID, "onCreate");
        onCreate.annotate(Override.class);
        JVar onCreateSavedInstanceState = onCreate.param(this.classes().BUNDLE, "savedInstanceState");
        JBlock onCreateBody = onCreate.body();
        JVar previousNotifier = this.viewNotifierHelper.replacePreviousNotifier(onCreateBody);
        this.setFindViewById();
        onCreateBody.invoke(this.getInit()).arg(onCreateSavedInstanceState);
        onCreateBody.invoke(JExpr._super(), onCreate).arg(onCreateSavedInstanceState);
        this.onCreateAfterSuperBlock = onCreateBody.block();
        this.viewNotifierHelper.resetPreviousNotifier(onCreateBody, previousNotifier);
    }

    private void setOnViewCreated() {
        JMethod onViewCreated = this.generatedClass.method(1, this.codeModel().VOID, "onViewCreated");
        onViewCreated.annotate(Override.class);
        JVar view = onViewCreated.param(this.classes().VIEW, "view");
        JVar savedInstanceState = onViewCreated.param(this.classes().BUNDLE, "savedInstanceState");
        JBlock onViewCreatedBody = onViewCreated.body();
        onViewCreatedBody.invoke(JExpr._super(), onViewCreated).arg(view).arg(savedInstanceState);
        this.viewNotifierHelper.invokeViewChanged(onViewCreatedBody);
    }

    private void setFindViewById() {
        JMethod findViewById = this.generatedClass.method(1, this.classes().VIEW, "findViewById");
        findViewById.annotate(Override.class);
        JVar idParam = findViewById.param(this.codeModel().INT, "id");
        JBlock body = findViewById.body();
        JFieldVar contentView = this.getContentView();
        body._if(contentView.eq(JExpr._null()))._then()._return(JExpr._null());
        body._return(contentView.invoke(findViewById).arg(idParam));
    }

    private void setFragmentBuilder() throws JClassAlreadyExistsException {
        this.fragmentBuilderClass = this.generatedClass._class(17, "FragmentBuilder_");
        this.narrowBuilderClass = this.narrow(this.fragmentBuilderClass);
        this.generify(this.fragmentBuilderClass);
        JClass superClass = this.refClass(FragmentBuilder.class);
        superClass = superClass.narrow(this.narrowBuilderClass, this.getAnnotatedClass());
        this.fragmentBuilderClass._extends(superClass);
        this.fragmentArgumentsBuilderField = JExpr.ref("args");
        this.setFragmentBuilderBuild();
        this.setFragmentBuilderCreate();
    }

    private JClass narrow(JClass toNarrow) {
        ArrayList<JClass> classes = new ArrayList<JClass>();
        for (JTypeVar type : this.generatedClass.typeParams()) {
            classes.add(this.codeModel().directClass(type.name()));
        }
        if (classes.isEmpty()) {
            return toNarrow;
        }
        return toNarrow.narrow(classes);
    }

    private void setFragmentBuilderBuild() {
        JMethod method = this.fragmentBuilderClass.method(1, this.generatedClass._extends(), "build");
        method.annotate(Override.class);
        JBlock body = method.body();
        JClass result = this.narrow(this.generatedClass);
        JVar fragment = body.decl(result, "fragment_", JExpr._new(result));
        body.invoke((JExpression)fragment, "setArguments").arg(this.fragmentArgumentsBuilderField);
        body._return(fragment);
    }

    private void setFragmentBuilderCreate() {
        JMethod method = this.generatedClass.method(17, this.narrowBuilderClass, "builder");
        this.generify(method);
        method.body()._return(JExpr._new(this.narrowBuilderClass));
    }

    private void generify(JGenerifiable generifiable) {
        for (JTypeVar type : this.generatedClass.typeParams()) {
            generifiable.generify(type.name(), type._extends());
        }
    }

    private void setOnCreateOptionsMenu() {
        JClass menuClass = this.classes().MENU;
        JClass menuInflaterClass = this.classes().MENU_INFLATER;
        if (this.usesActionBarSherlock()) {
            menuClass = this.classes().SHERLOCK_MENU;
            menuInflaterClass = this.classes().SHERLOCK_MENU_INFLATER;
        }
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onCreateOptionsMenu");
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        this.onCreateOptionsMenuMenuParam = method.param(menuClass, "menu");
        this.onCreateOptionsMenuMenuInflaterVar = method.param(menuInflaterClass, "inflater");
        this.onCreateOptionsMenuMethodBody = methodBody.block();
        methodBody.invoke(JExpr._super(), method).arg(this.onCreateOptionsMenuMenuParam).arg(this.onCreateOptionsMenuMenuInflaterVar);
        this.getInitBody().invoke("setHasOptionsMenu").arg(JExpr.TRUE);
    }

    private void setOnOptionsItemSelected() {
        JClass menuItemClass = this.classes().MENU_ITEM;
        if (this.usesActionBarSherlock()) {
            menuItemClass = this.classes().SHERLOCK_MENU_ITEM;
        }
        JMethod method = this.generatedClass.method(1, this.codeModel().BOOLEAN, "onOptionsItemSelected");
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        this.onOptionsItemSelectedItem = method.param(menuItemClass, "item");
        JVar handled = methodBody.decl(this.codeModel().BOOLEAN, "handled", JExpr.invoke(JExpr._super(), method).arg(this.onOptionsItemSelectedItem));
        methodBody._if(handled)._then()._return(JExpr.TRUE);
        this.onOptionsItemSelectedItemId = methodBody.decl(this.codeModel().INT, "itemId_", this.onOptionsItemSelectedItem.invoke("getItemId"));
        this.onOptionsItemSelectedIfElseBlock = methodBody.block();
        methodBody._return(JExpr.FALSE);
    }

    private boolean usesActionBarSherlock() {
        return new ActionBarSherlockHelper(new AnnotationHelper(this.processingEnvironment())).usesActionBarSherlock(this);
    }

    @Override
    protected void setContextRef() {
        this.contextRef = JExpr.invoke("getActivity");
    }

    @Override
    protected void setInit() {
        this.init = this.generatedClass.method(4, this.codeModel().VOID, "init_");
        this.init.param(this.classes().BUNDLE, "savedInstanceState");
    }

    public JFieldVar getContentView() {
        if (this.contentView == null) {
            this.setContentView();
            this.setOnCreateView();
            this.setOnDestroyView();
        }
        return this.contentView;
    }

    private void setContentView() {
        this.contentView = this.generatedClass.field(4, this.classes().VIEW, "contentView_");
    }

    private void setOnCreateView() {
        JMethod onCreateView = this.generatedClass.method(1, this.classes().VIEW, "onCreateView");
        onCreateView.annotate(Override.class);
        this.inflater = onCreateView.param(this.classes().LAYOUT_INFLATER, "inflater");
        this.container = onCreateView.param(this.classes().VIEW_GROUP, "container");
        JVar savedInstanceState = onCreateView.param(this.classes().BUNDLE, "savedInstanceState");
        JBlock body = onCreateView.body();
        body.assign(this.contentView, JExpr._super().invoke(onCreateView).arg(this.inflater).arg(this.container).arg(savedInstanceState));
        this.setContentViewBlock = body.block();
        body._return(this.contentView);
    }

    private void setOnDestroyView() {
        JMethod onDestroyView = this.generatedClass.method(1, this.codeModel().VOID, "onDestroyView");
        onDestroyView.annotate(Override.class);
        JBlock body = onDestroyView.body();
        body.assign(this.contentView, JExpr._null());
        body.invoke(JExpr._super(), onDestroyView);
    }

    private void setOnStart() {
        JMethod onStart = this.generatedClass.method(1, this.codeModel().VOID, "onStart");
        onStart.annotate(Override.class);
        JBlock onStartBody = onStart.body();
        onStartBody.invoke(JExpr._super(), onStart);
        this.onStartAfterSuperBlock = onStartBody.block();
    }

    private void setOnAttach() {
        JMethod onAttach = this.generatedClass.method(1, this.codeModel().VOID, "onAttach");
        onAttach.annotate(Override.class);
        JVar activityParam = onAttach.param(this.classes().ACTIVITY, "activity");
        JBlock onAttachBody = onAttach.body();
        onAttachBody.invoke(JExpr._super(), onAttach).arg(activityParam);
        this.onAttachAfterSuperBlock = onAttachBody.block();
    }

    private void setOnResume() {
        JMethod onResume = this.generatedClass.method(1, this.codeModel().VOID, "onResume");
        onResume.annotate(Override.class);
        JBlock onResumeBody = onResume.body();
        onResumeBody.invoke(JExpr._super(), onResume);
        this.onResumeAfterSuperBlock = onResumeBody.block();
    }

    private void setOnPause() {
        JMethod onPause = this.generatedClass.method(1, this.codeModel().VOID, "onPause");
        onPause.annotate(Override.class);
        JBlock onPauseBody = onPause.body();
        this.onPauseBeforeSuperBlock = onPauseBody.block();
        onPauseBody.invoke(JExpr._super(), onPause);
    }

    private void setOnDetach() {
        JMethod onDetach = this.generatedClass.method(1, this.codeModel().VOID, "onDetach");
        onDetach.annotate(Override.class);
        JBlock onDetachBody = onDetach.body();
        this.onDetachBeforeSuperBlock = onDetachBody.block();
        onDetachBody.invoke(JExpr._super(), onDetach);
    }

    private void setOnStop() {
        JMethod onStop = this.generatedClass.method(1, this.codeModel().VOID, "onStop");
        onStop.annotate(Override.class);
        JBlock onStopBody = onStop.body();
        this.onStopBeforeSuperBlock = onStopBody.block();
        onStopBody.invoke(JExpr._super(), onStop);
    }

    private void setOnDestroy() {
        JMethod onDestroy = this.generatedClass.method(1, this.codeModel().VOID, "onDestroy");
        onDestroy.annotate(Override.class);
        JBlock onDestroyBody = onDestroy.body();
        this.onDestroyBeforeSuperBlock = onDestroyBody.block();
        onDestroyBody.invoke(JExpr._super(), onDestroy);
    }

    public JBlock getSetContentViewBlock() {
        if (this.setContentViewBlock == null) {
            this.setOnCreateView();
        }
        return this.setContentViewBlock;
    }

    public JVar getInflater() {
        if (this.inflater == null) {
            this.setOnCreateView();
        }
        return this.inflater;
    }

    public JVar getContainer() {
        if (this.container == null) {
            this.setOnCreateView();
        }
        return this.container;
    }

    public JDefinedClass getBuilderClass() {
        return this.fragmentBuilderClass;
    }

    public JFieldRef getBuilderArgsField() {
        return this.fragmentArgumentsBuilderField;
    }

    public JMethod getInjectArgsMethod() {
        if (this.injectArgsMethod == null) {
            this.setInjectArgs();
        }
        return this.injectArgsMethod;
    }

    public JBlock getInjectArgsBlock() {
        if (this.injectArgsBlock == null) {
            this.setInjectArgs();
        }
        return this.injectArgsBlock;
    }

    public JVar getInjectBundleArgs() {
        if (this.injectBundleArgs == null) {
            this.setInjectArgs();
        }
        return this.injectBundleArgs;
    }

    private void setInjectArgs() {
        this.injectArgsMethod = this.generatedClass.method(4, this.codeModel().VOID, "injectFragmentArguments_");
        JBlock injectExtrasBody = this.injectArgsMethod.body();
        this.injectBundleArgs = injectExtrasBody.decl(this.classes().BUNDLE, "args_", JExpr.invoke("getArguments"));
        this.injectArgsBlock = injectExtrasBody._if(this.injectBundleArgs.ne(JExpr._null()))._then();
        this.getInitBody().invoke(this.injectArgsMethod);
    }

    @Override
    public JBlock getSaveStateMethodBody() {
        return this.instanceStateHolder.getSaveStateMethodBody();
    }

    @Override
    public JVar getSaveStateBundleParam() {
        return this.instanceStateHolder.getSaveStateBundleParam();
    }

    @Override
    public JMethod getRestoreStateMethod() {
        return this.instanceStateHolder.getRestoreStateMethod();
    }

    @Override
    public JVar getRestoreStateBundleParam() {
        return this.instanceStateHolder.getRestoreStateBundleParam();
    }

    @Override
    public JBlock getOnCreateOptionsMenuMethodBody() {
        if (this.onCreateOptionsMenuMethodBody == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMethodBody;
    }

    @Override
    public JVar getOnCreateOptionsMenuMenuInflaterVar() {
        if (this.onCreateOptionsMenuMenuInflaterVar == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMenuInflaterVar;
    }

    @Override
    public JVar getOnCreateOptionsMenuMenuParam() {
        if (this.onCreateOptionsMenuMenuParam == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMenuParam;
    }

    @Override
    public JVar getOnOptionsItemSelectedItem() {
        if (this.onOptionsItemSelectedItem == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedItem;
    }

    @Override
    public JVar getOnOptionsItemSelectedItemId() {
        if (this.onOptionsItemSelectedItemId == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedItemId;
    }

    @Override
    public JBlock getOnOptionsItemSelectedIfElseBlock() {
        if (this.onOptionsItemSelectedIfElseBlock == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedIfElseBlock;
    }

    @Override
    public JBlock getOnActivityResultCaseBlock(int requestCode) {
        return this.onActivityResultHolder.getCaseBlock(requestCode);
    }

    @Override
    public JVar getOnActivityResultDataParam() {
        return this.onActivityResultHolder.getDataParam();
    }

    @Override
    public JVar getOnActivityResultResultCodeParam() {
        return this.onActivityResultHolder.getResultCodeParam();
    }

    @Override
    public JMethod getOnActivityResultMethod() {
        return this.onActivityResultHolder.getMethod();
    }

    @Override
    public JFieldVar getIntentFilterField(String[] actions, String[] dataSchemes) {
        return this.receiverRegistrationHolder.getIntentFilterField(actions, dataSchemes);
    }

    @Override
    public JBlock getOnCreateAfterSuperBlock() {
        if (this.onCreateAfterSuperBlock == null) {
            this.setOnCreate();
        }
        return this.onCreateAfterSuperBlock;
    }

    @Override
    public JBlock getOnDestroyBeforeSuperBlock() {
        if (this.onDestroyBeforeSuperBlock == null) {
            this.setOnDestroy();
        }
        return this.onDestroyBeforeSuperBlock;
    }

    @Override
    public JBlock getOnStartAfterSuperBlock() {
        if (this.onStartAfterSuperBlock == null) {
            this.setOnStart();
        }
        return this.onStartAfterSuperBlock;
    }

    @Override
    public JBlock getOnStopBeforeSuperBlock() {
        if (this.onStopBeforeSuperBlock == null) {
            this.setOnStop();
        }
        return this.onStopBeforeSuperBlock;
    }

    @Override
    public JBlock getOnResumeAfterSuperBlock() {
        if (this.onResumeAfterSuperBlock == null) {
            this.setOnResume();
        }
        return this.onResumeAfterSuperBlock;
    }

    @Override
    public JBlock getOnPauseBeforeSuperBlock() {
        if (this.onPauseBeforeSuperBlock == null) {
            this.setOnPause();
        }
        return this.onPauseBeforeSuperBlock;
    }

    @Override
    public JBlock getOnAttachAfterSuperBlock() {
        if (this.onAttachAfterSuperBlock == null) {
            this.setOnAttach();
        }
        return this.onAttachAfterSuperBlock;
    }

    @Override
    public JBlock getOnDetachBeforeSuperBlock() {
        if (this.onDetachBeforeSuperBlock == null) {
            this.setOnDetach();
        }
        return this.onDetachBeforeSuperBlock;
    }
}

