/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.androidannotations.api.sharedpreferences.BooleanPrefEditorField;
import org.androidannotations.api.sharedpreferences.EditorHelper;
import org.androidannotations.api.sharedpreferences.FloatPrefEditorField;
import org.androidannotations.api.sharedpreferences.IntPrefEditorField;
import org.androidannotations.api.sharedpreferences.LongPrefEditorField;
import org.androidannotations.api.sharedpreferences.SharedPreferencesHelper;
import org.androidannotations.api.sharedpreferences.StringPrefEditorField;
import org.androidannotations.api.sharedpreferences.StringSetPrefEditorField;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.BaseGeneratedClassHolder;
import org.androidannotations.process.ProcessHolder;

public class SharedPrefHolder
extends BaseGeneratedClassHolder {
    private static final Map<String, EditorFieldHolder> EDITOR_FIELD_BY_TYPE = new HashMap<String, EditorFieldHolder>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("boolean", new EditorFieldHolder(BooleanPrefEditorField.class, "booleanField"));
            this.put("float", new EditorFieldHolder(FloatPrefEditorField.class, "floatField"));
            this.put("int", new EditorFieldHolder(IntPrefEditorField.class, "intField"));
            this.put("long", new EditorFieldHolder(LongPrefEditorField.class, "longField"));
            this.put(CanonicalNameConstants.STRING, new EditorFieldHolder(StringPrefEditorField.class, "stringField"));
            this.put("java.util.Set<java.lang.String>", new EditorFieldHolder(StringSetPrefEditorField.class, "stringSetField"));
        }
    };
    private JMethod constructor;
    private JBlock constructorSuperBlock;
    private JVar constructorContextParam;
    private JFieldVar contextField;
    private JDefinedClass editorClass;
    private JFieldVar editorContextField;
    private JMethod editorConstructor;
    private JInvocation editMethodEditorInvocation;

    public SharedPrefHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        super(processHolder, annotatedElement);
        this.createEditorClass();
        this.createEditMethod();
    }

    @Override
    protected void setExtends() {
        this.generatedClass._extends(SharedPreferencesHelper.class);
    }

    private void createEditorClass() throws JClassAlreadyExistsException {
        String interfaceSimpleName = this.annotatedElement.getSimpleName().toString();
        this.editorClass = this.generatedClass._class(25, interfaceSimpleName + "Editor" + "_");
        this.editorClass._extends(this.processHolder.refClass(EditorHelper.class).narrow((JClass)this.editorClass));
        this.createEditorConstructor();
    }

    private void createEditorConstructor() {
        this.editorConstructor = this.editorClass.constructor(0);
        JClass sharedPreferencesClass = this.processHolder.refClass("android.content.SharedPreferences");
        JVar sharedPreferencesParam = this.editorConstructor.param(sharedPreferencesClass, "sharedPreferences");
        this.editorConstructor.body().invoke("super").arg(sharedPreferencesParam);
    }

    private void createEditMethod() {
        JMethod editMethod = this.generatedClass.method(1, this.editorClass, "edit");
        this.editMethodEditorInvocation = JExpr._new(this.editorClass).arg(JExpr.invoke("getSharedPreferences"));
        editMethod.body()._return(this.editMethodEditorInvocation);
    }

    public void createFieldMethod(Class<?> prefFieldHelperClass, JExpression keyExpression, String fieldName, String fieldHelperMethodName, JExpression defaultValue) {
        JMethod fieldMethod = this.generatedClass.method(1, prefFieldHelperClass, fieldName);
        fieldMethod.body()._return(JExpr.invoke(fieldHelperMethodName).arg(keyExpression).arg(defaultValue));
    }

    public void createEditorFieldMethods(ExecutableElement method, JExpression keyExpression) {
        String returnType = method.getReturnType().toString();
        EditorFieldHolder editorFieldHolder = EDITOR_FIELD_BY_TYPE.get(returnType);
        JClass editorFieldClass = this.processHolder.refClass(editorFieldHolder.fieldClass);
        String fieldName = method.getSimpleName().toString();
        JMethod editorFieldMethod = this.editorClass.method(1, editorFieldClass.narrow((JClass)this.editorClass), fieldName);
        editorFieldMethod.body()._return(JExpr.invoke(editorFieldHolder.fieldMethodName).arg(keyExpression));
    }

    public JBlock getConstructorSuperBlock() {
        if (this.constructorSuperBlock == null) {
            this.setConstructor();
        }
        return this.constructorSuperBlock;
    }

    public JVar getConstructorContextParam() {
        if (this.constructorContextParam == null) {
            this.setConstructor();
        }
        return this.constructorContextParam;
    }

    public JMethod getConstructor() {
        if (this.constructor == null) {
            this.setConstructor();
        }
        return this.constructor;
    }

    private void setConstructor() {
        this.constructor = this.generatedClass.constructor(1);
        this.constructorContextParam = this.constructor.param(this.classes().CONTEXT, "context");
        JBlock constructorBody = this.constructor.body();
        this.constructorSuperBlock = constructorBody.block();
    }

    public JFieldVar getContextField() {
        if (this.contextField == null) {
            this.setContextField();
        }
        return this.contextField;
    }

    protected void setContextField() {
        this.contextField = this.generatedClass.field(4, this.classes().CONTEXT, "context_");
        this.getConstructor().body().assign(JExpr._this().ref(this.contextField), this.getConstructorContextParam());
    }

    public JFieldVar getEditorContextField() {
        if (this.editorContextField == null) {
            this.setEditorContextField();
        }
        return this.editorContextField;
    }

    protected void setEditorContextField() {
        this.editorContextField = this.editorClass.field(4, this.classes().CONTEXT, "context_");
        JVar contextParam = this.editorConstructor.param(this.classes().CONTEXT, "context");
        this.editorConstructor.body().assign(JExpr._this().ref(this.editorContextField), contextParam);
        this.editMethodEditorInvocation.arg(this.getContextField());
    }

    private static class EditorFieldHolder {
        public final Class<?> fieldClass;
        public final String fieldMethodName;

        public EditorFieldHolder(Class<?> fieldClass, String fieldMethodName) {
            this.fieldClass = fieldClass;
            this.fieldMethodName = fieldMethodName;
        }
    }
}

