/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public abstract class AbstractListenerHandler<T extends GeneratedClassHolder>
extends BaseAnnotationHandler<T> {
    private IdAnnotationHelper helper;
    private T holder;
    private String methodName;

    public AbstractListenerHandler(Class<?> targetClass, ProcessingEnvironment processingEnvironment) {
        super(targetClass, processingEnvironment);
    }

    public AbstractListenerHandler(String target, ProcessingEnvironment processingEnvironment) {
        super(target, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.helper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.resIdsExist(element, this.getResourceType(), IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        this.validatorHelper.uniqueResourceId(element, validatedElements, this.getResourceType(), valid);
    }

    @Override
    public void process(Element element, T holder) {
        this.holder = holder;
        this.methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        TypeMirror returnType = executableElement.getReturnType();
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(this.processHolder, element, this.getResourceType(), true);
        JDefinedClass listenerAnonymousClass = this.codeModel().anonymousClass(this.getListenerClass());
        JMethod listenerMethod = this.createListenerMethod(listenerAnonymousClass);
        listenerMethod.annotate(Override.class);
        JBlock listenerMethodBody = listenerMethod.body();
        JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
        JInvocation call = JExpr.invoke((JExpression)activityRef, this.methodName);
        this.makeCall(listenerMethodBody, call, returnType);
        this.processParameters(holder, listenerMethod, call, parameters);
        this.assignListeners(holder, idsRefs, listenerAnonymousClass);
    }

    protected abstract void assignListeners(T var1, List<JFieldRef> var2, JDefinedClass var3);

    protected abstract void makeCall(JBlock var1, JInvocation var2, TypeMirror var3);

    protected abstract void processParameters(T var1, JMethod var2, JInvocation var3, List<? extends VariableElement> var4);

    protected abstract JMethod createListenerMethod(JDefinedClass var1);

    protected abstract String getSetterName();

    protected abstract JClass getListenerClass();

    protected abstract JClass getListenerTargetClass();

    protected String getMethodName() {
        return this.methodName;
    }

    protected final T getHolder() {
        return this.holder;
    }

    protected abstract IRClass.Res getResourceType();
}

