/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.annotations.PreferenceHeaders;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.HasPreferenceHeaders;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class PreferenceHeadersHandler
extends BaseAnnotationHandler<HasPreferenceHeaders> {
    private final AnnotationHelper annotationHelper;

    public PreferenceHeadersHandler(ProcessingEnvironment processingEnvironment) {
        super(PreferenceHeaders.class, processingEnvironment);
        this.annotationHelper = new AnnotationHelper(processingEnvironment);
    }

    @Override
    protected void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.isPreferenceFragmentClassPresent(element, valid);
        this.validatorHelper.extendsPreferenceActivity(element, valid);
        this.validatorHelper.hasEActivity(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.XML, IdValidatorHelper.FallbackStrategy.NEED_RES_ID, valid);
    }

    @Override
    public void process(Element element, HasPreferenceHeaders holder) throws Exception {
        JFieldRef headerId = this.annotationHelper.extractAnnotationFieldRefs(this.processHolder, element, this.getTarget(), this.rClass.get(IRClass.Res.XML), false).get(0);
        JBlock block = holder.getOnBuildHeadersBlock();
        JVar targetParam = holder.getOnBuildHeadersTargetParam();
        block.invoke("loadHeadersFromResource").arg(headerId).arg(targetParam);
        block.invoke(JExpr._super(), "onBuildHeaders").arg(targetParam);
    }
}

