/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.annotations.Receiver;
import org.androidannotations.handler.AnnotationHandlers;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.ExtraParameterHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.HasReceiverRegistration;
import org.androidannotations.holder.ReceiverRegistrationHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ReceiverHandler
extends BaseAnnotationHandler<HasReceiverRegistration> {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    private ExtraHandler extraHandler;

    public ReceiverHandler(ProcessingEnvironment processingEnvironment) {
        super(Receiver.class, processingEnvironment);
        this.extraHandler = new ExtraHandler(processingEnvironment);
    }

    public void register(AnnotationHandlers annotationHandlers) {
        annotationHandlers.add(this);
        annotationHandlers.add(this.extraHandler);
    }

    @Override
    protected void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragmentOrEServiceOrEIntentService(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, valid);
        this.validatorHelper.param.hasNoOtherParameterThanContextOrIntentOrReceiverExtraAnnotated((ExecutableElement)element, valid);
        this.validatorHelper.hasNotMultipleAnnotatedMethodWithSameName(element.getEnclosingElement(), valid, Receiver.class);
        this.validatorHelper.hasRightRegisterAtValueDependingOnEnclosingElement(element, valid);
        this.validatorHelper.hasSupportV4JarIfLocal(element, valid);
    }

    @Override
    public void process(Element element, HasReceiverRegistration holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        String receiverName = methodName + "Receiver" + "_";
        Receiver annotation = element.getAnnotation(Receiver.class);
        String[] actions = annotation.actions();
        String[] dataSchemes = annotation.dataSchemes();
        Receiver.RegisterAt registerAt = annotation.registerAt();
        boolean local = annotation.local();
        JFieldVar intentFilterField = holder.getIntentFilterField(new ReceiverRegistrationHolder.IntentFilterData(actions, dataSchemes, registerAt));
        JFieldVar receiverField = this.createReceiverField(holder, receiverName, methodName, (ExecutableElement)element);
        this.registerAndUnregisterReceiver(holder, registerAt, intentFilterField, receiverField, local);
    }

    private JFieldVar createReceiverField(HasReceiverRegistration holder, String receiverName, String methodName, ExecutableElement executableElement) {
        JDefinedClass anonymousReceiverClass = this.codeModel().anonymousClass(this.classes().BROADCAST_RECEIVER);
        JMethod onReceiveMethod = anonymousReceiverClass.method(1, this.codeModel().VOID, "onReceive");
        JVar contextVar = onReceiveMethod.param(this.classes().CONTEXT, "context");
        JVar intentVar = onReceiveMethod.param(this.classes().INTENT, "intent");
        JBlock body = onReceiveMethod.body();
        JFieldRef receiverRef = holder.getGeneratedClass().staticRef("this");
        JInvocation methodCall = receiverRef.invoke(methodName);
        JVar extras = null;
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        for (VariableElement variableElement : methodParameters) {
            JClass extraParamClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType(), holder);
            if (extraParamClass.equals(this.classes().CONTEXT)) {
                methodCall.arg(contextVar);
                continue;
            }
            if (extraParamClass.equals(this.classes().INTENT)) {
                methodCall.arg(intentVar);
                continue;
            }
            if (variableElement.getAnnotation(Receiver.Extra.class) == null) continue;
            if (extras == null) {
                extras = body.decl(this.classes().BUNDLE, "extras_", JOp.cond(intentVar.invoke("getExtras").ne(JExpr._null()), intentVar.invoke("getExtras"), JExpr._new(this.classes().BUNDLE)));
            }
            methodCall.arg(this.extraHandler.getExtraValue(variableElement, intentVar, extras, body, onReceiveMethod, anonymousReceiverClass, holder));
        }
        body.add(methodCall);
        JInvocation receiverInit = JExpr._new(anonymousReceiverClass);
        return holder.getGeneratedClass().field(12, this.classes().BROADCAST_RECEIVER, receiverName, (JExpression)receiverInit);
    }

    private void registerAndUnregisterReceiver(HasReceiverRegistration holder, Receiver.RegisterAt registerAt, JFieldVar intentFilterField, JFieldVar receiverField, boolean local) {
        JBlock registerBlock = null;
        JBlock unregisterBlock = null;
        switch (registerAt) {
            case OnCreateOnDestroy: {
                registerBlock = holder.getOnCreateAfterSuperBlock();
                unregisterBlock = holder.getOnDestroyBeforeSuperBlock();
                break;
            }
            case OnStartOnStop: {
                registerBlock = holder.getOnStartAfterSuperBlock();
                unregisterBlock = holder.getOnStopBeforeSuperBlock();
                break;
            }
            case OnResumeOnPause: {
                registerBlock = holder.getOnResumeAfterSuperBlock();
                unregisterBlock = holder.getOnPauseBeforeSuperBlock();
                break;
            }
            case OnAttachOnDetach: {
                registerBlock = holder.getOnAttachAfterSuperBlock();
                unregisterBlock = holder.getOnDetachBeforeSuperBlock();
            }
        }
        JExpression broadcastManager = local ? this.classes().LOCAL_BROADCAST_MANAGER.staticInvoke("getInstance").arg(holder.getContextRef()) : holder.getContextRef();
        registerBlock.invoke(broadcastManager, "registerReceiver").arg(receiverField).arg(intentFilterField);
        unregisterBlock.invoke(broadcastManager, "unregisterReceiver").arg(receiverField);
    }

    private static class ExtraHandler
    extends ExtraParameterHandler {
        public ExtraHandler(ProcessingEnvironment processingEnvironment) {
            super(Receiver.Extra.class, Receiver.class, processingEnvironment);
        }

        @Override
        public String getAnnotationValue(VariableElement parameter) {
            return parameter.getAnnotation(Receiver.Extra.class).value();
        }
    }
}

