/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler.rest;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.rest.Rest;
import org.androidannotations.annotations.rest.RestService;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class RestServiceHandler
extends BaseAnnotationHandler<EComponentHolder> {
    public RestServiceHandler(ProcessingEnvironment processingEnvironment) {
        super(RestService.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.typeHasAnnotation(Rest.class, element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror fieldTypeMirror = element.asType();
        String interfaceName = fieldTypeMirror.toString();
        String generatedClassName = interfaceName + "_";
        JBlock methodBody = holder.getInitBody();
        JFieldRef field = JExpr.ref(fieldName);
        methodBody.assign(field, JExpr._new(this.refClass(generatedClassName)).arg(holder.getContextRef()));
    }
}

