/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CaseHelper {
    private static final Pattern PATTERN = Pattern.compile("([A-Z]|[a-z])[a-z0-9]*");

    private CaseHelper() {
    }

    public static String camelCaseToSnakeCase(String camelCase) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher matcher = PATTERN.matcher(camelCase);
        String acronym = "";
        while (matcher.find()) {
            String found = matcher.group();
            if (found.matches("^[A-Z]$")) {
                acronym = acronym + found;
                continue;
            }
            if (acronym.length() > 0) {
                tokens.add(acronym);
                acronym = "";
            }
            tokens.add(found.toLowerCase());
        }
        if (acronym.length() > 0) {
            tokens.add(acronym);
        }
        if (tokens.size() > 0) {
            StringBuilder sb = new StringBuilder((String)tokens.remove(0));
            for (String s : tokens) {
                sb.append("_").append(s);
            }
            return sb.toString();
        }
        return camelCase;
    }

    public static String camelCaseToUpperSnakeCase(String camelCase) {
        return CaseHelper.camelCaseToSnakeCase(camelCase).toUpperCase();
    }

    public static String lowerCaseFirst(String string) {
        if (string.length() < 2) {
            return string.toLowerCase();
        }
        String first = string.substring(0, 1).toLowerCase();
        String end = string.substring(1, string.length());
        return first + end;
    }

    public static String camelCaseToUpperSnakeCase(String prefix, String camelCase, String suffix) {
        if (prefix != null && !camelCase.startsWith(prefix)) {
            camelCase = prefix + "_" + camelCase;
        }
        if (suffix != null && !camelCase.toLowerCase().endsWith(suffix.toLowerCase())) {
            camelCase = camelCase + "_" + suffix;
        }
        return CaseHelper.camelCaseToUpperSnakeCase(camelCase);
    }
}

