/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.api.SdkVersionHelper;
import org.androidannotations.helper.ActionBarSherlockHelper;
import org.androidannotations.helper.ActivityIntentBuilder;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.IntentBuilder;
import org.androidannotations.helper.OrmLiteHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.FoundPreferenceHolder;
import org.androidannotations.holder.HasExtras;
import org.androidannotations.holder.HasInstanceState;
import org.androidannotations.holder.HasIntentBuilder;
import org.androidannotations.holder.HasOnActivityResult;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.holder.HasPreferenceHeaders;
import org.androidannotations.holder.HasReceiverRegistration;
import org.androidannotations.holder.InstanceStateHolder;
import org.androidannotations.holder.NonConfigurationHolder;
import org.androidannotations.holder.OnActivityResultHolder;
import org.androidannotations.holder.PreferenceActivityHolder;
import org.androidannotations.holder.ReceiverRegistrationHolder;
import org.androidannotations.holder.RoboGuiceHolder;
import org.androidannotations.process.ProcessHolder;

public class EActivityHolder
extends EComponentWithViewSupportHolder
implements HasIntentBuilder,
HasExtras,
HasInstanceState,
HasOptionsMenu,
HasOnActivityResult,
HasReceiverRegistration,
HasPreferenceHeaders {
    private static final String ON_CONTENT_CHANGED_JAVADOC = "We cannot simply copy the code from RoboActivity, because that can cause classpath issues. For further details see issue #1116.";
    private ActivityIntentBuilder intentBuilder;
    private JMethod onCreate;
    private JMethod setIntent;
    private JMethod onNewIntentMethod;
    private JMethod setContentViewLayout;
    private JVar initSavedInstanceParam;
    private JDefinedClass intentBuilderClass;
    private InstanceStateHolder instanceStateHolder = new InstanceStateHolder(this);
    private OnActivityResultHolder onActivityResultHolder = new OnActivityResultHolder(this);
    private ReceiverRegistrationHolder<EActivityHolder> receiverRegistrationHolder = new ReceiverRegistrationHolder<EActivityHolder>(this);
    private RoboGuiceHolder roboGuiceHolder;
    private PreferenceActivityHolder preferencesHolder = new PreferenceActivityHolder(this);
    private JMethod injectExtrasMethod;
    private JBlock injectExtrasBlock;
    private JVar injectExtras;
    private JBlock onCreateOptionsMenuMethodBody;
    private JVar onCreateOptionsMenuMenuInflaterVar;
    private JVar onCreateOptionsMenuMenuParam;
    private JVar onOptionsItemSelectedItem;
    private JVar onOptionsItemSelectedItemId;
    private JBlock onOptionsItemSelectedMiddleBlock;
    private NonConfigurationHolder nonConfigurationHolder;
    private JBlock initIfNonConfigurationNotNullBlock;
    private JVar initNonConfigurationInstance;
    private JMethod getLastNonConfigurationInstance;
    private JBlock onRetainNonConfigurationInstanceBindBlock;
    private JVar onRetainNonConfigurationInstance;
    private JBlock onDestroyBeforeSuperBlock;
    private JBlock onDestroyAfterSuperBlock;
    private JBlock onResumeAfterSuperBlock;
    private JBlock onStartAfterSuperBlock;
    private JBlock onStopBeforeSuperBlock;
    private JBlock onPauseBeforeSuperBlock;

    public EActivityHolder(ProcessHolder processHolder, TypeElement annotatedElement, AndroidManifest androidManifest) throws Exception {
        super(processHolder, annotatedElement);
        this.setSetContentView();
        this.intentBuilder = new ActivityIntentBuilder(this, androidManifest);
        this.intentBuilder.build();
        this.handleBackPressed();
    }

    @Override
    protected void setContextRef() {
        this.contextRef = JExpr._this();
    }

    @Override
    protected void setInit() {
        this.init = this.generatedClass.method(4, this.codeModel().VOID, "init_");
        JClass bundleClass = this.classes().BUNDLE;
        this.initSavedInstanceParam = this.init.param(bundleClass, "savedInstanceState");
        this.getOnCreate();
    }

    public JMethod getOnCreate() {
        if (this.onCreate == null) {
            this.setOnCreate();
        }
        return this.onCreate;
    }

    public JMethod getSetIntent() {
        if (this.setIntent == null) {
            this.setSetIntent();
        }
        return this.setIntent;
    }

    protected void setOnCreate() {
        this.onCreate = this.generatedClass.method(1, this.codeModel().VOID, "onCreate");
        this.onCreate.annotate(Override.class);
        JClass bundleClass = this.classes().BUNDLE;
        JVar onCreateSavedInstanceState = this.onCreate.param(bundleClass, "savedInstanceState");
        JBlock onCreateBody = this.onCreate.body();
        JVar previousNotifier = this.viewNotifierHelper.replacePreviousNotifier(onCreateBody);
        onCreateBody.invoke(this.getInit()).arg(onCreateSavedInstanceState);
        onCreateBody.invoke(JExpr._super(), this.onCreate).arg(onCreateSavedInstanceState);
        this.viewNotifierHelper.resetPreviousNotifier(onCreateBody, previousNotifier);
    }

    protected void setOnStart() {
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onStart");
        method.annotate(Override.class);
        JBlock body = method.body();
        this.getRoboGuiceHolder().onStartBeforeSuperBlock = body.block();
        body.invoke(JExpr._super(), method);
        this.onStartAfterSuperBlock = body.block();
    }

    protected void setOnRestart() {
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onRestart");
        method.annotate(Override.class);
        JBlock body = method.body();
        this.getRoboGuiceHolder().onRestartBeforeSuperBlock = body.block();
        body.invoke(JExpr._super(), method);
        this.getRoboGuiceHolder().onRestartAfterSuperBlock = body.block();
    }

    protected void setOnResume() {
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onResume");
        method.annotate(Override.class);
        JBlock body = method.body();
        this.getRoboGuiceHolder().onResumeBeforeSuperBlock = body.block();
        body.invoke(JExpr._super(), method);
        this.onResumeAfterSuperBlock = body.block();
    }

    protected void setOnPause() {
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onPause");
        method.annotate(Override.class);
        JBlock body = method.body();
        this.onPauseBeforeSuperBlock = body.block();
        body.invoke(JExpr._super(), method);
        this.getRoboGuiceHolder().onPauseAfterSuperBlock = body.block();
    }

    protected void setOnNewIntent() {
        this.onNewIntentMethod = this.generatedClass.method(1, this.codeModel().VOID, "onNewIntent");
        this.onNewIntentMethod.annotate(Override.class);
        JVar intent = this.onNewIntentMethod.param(this.classes().INTENT, "intent");
        JBlock body = this.onNewIntentMethod.body();
        body.invoke(JExpr._super(), this.onNewIntentMethod).arg(intent);
        body.invoke(this.getSetIntent()).arg(intent);
        this.getRoboGuiceHolder().onNewIntentAfterSuperBlock = body.block();
    }

    private void setSetIntent() {
        this.setIntent = this.generatedClass.method(1, this.codeModel().VOID, "setIntent");
        this.setIntent.annotate(Override.class);
        JVar methodParam = this.setIntent.param(this.classes().INTENT, "newIntent");
        JBlock setIntentBody = this.setIntent.body();
        setIntentBody.invoke(JExpr._super(), this.setIntent).arg(methodParam);
    }

    protected void setOnStop() {
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onStop");
        method.annotate(Override.class);
        JBlock body = method.body();
        this.onStopBeforeSuperBlock = body.block();
        body.invoke(JExpr._super(), method);
        this.getRoboGuiceHolder().onStop = method;
    }

    protected void setOnDestroy() {
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onDestroy");
        method.annotate(Override.class);
        JBlock body = method.body();
        this.getRoboGuiceHolder().onDestroy = method;
        this.onDestroyBeforeSuperBlock = body.block();
        body.invoke(JExpr._super(), method);
        this.onDestroyAfterSuperBlock = body.block();
    }

    protected void setOnConfigurationChanged() {
        JVar newConfig;
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onConfigurationChanged");
        method.annotate(Override.class);
        JClass configurationClass = this.classes().CONFIGURATION;
        this.getRoboGuiceHolder().newConfig = newConfig = method.param(configurationClass, "newConfig");
        JBlock body = method.body();
        this.getRoboGuiceHolder().currentConfig = body.decl(configurationClass, "currentConfig", JExpr.invoke("getResources").invoke("getConfiguration"));
        body.invoke(JExpr._super(), method).arg(newConfig);
        this.getRoboGuiceHolder().onConfigurationChangedAfterSuperBlock = body.block();
    }

    protected void setOnContentChanged() {
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onContentChanged");
        method.annotate(Override.class);
        method.javadoc().append(ON_CONTENT_CHANGED_JAVADOC);
        JBlock body = method.body();
        body.invoke(JExpr._super(), method);
        this.getRoboGuiceHolder().onContentChangedAfterSuperBlock = body.block();
    }

    private void setOnCreateOptionsMenu() {
        JClass menuClass = this.classes().MENU;
        JClass menuInflaterClass = this.classes().MENU_INFLATER;
        String getMenuInflaterMethodName = "getMenuInflater";
        if (this.usesActionBarSherlock()) {
            menuClass = this.classes().SHERLOCK_MENU;
            menuInflaterClass = this.classes().SHERLOCK_MENU_INFLATER;
            getMenuInflaterMethodName = "getSupportMenuInflater";
        }
        JMethod method = this.generatedClass.method(1, this.codeModel().BOOLEAN, "onCreateOptionsMenu");
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        this.onCreateOptionsMenuMenuParam = method.param(menuClass, "menu");
        this.onCreateOptionsMenuMenuInflaterVar = methodBody.decl(menuInflaterClass, "menuInflater", JExpr.invoke(getMenuInflaterMethodName));
        this.onCreateOptionsMenuMethodBody = methodBody.block();
        methodBody._return(JExpr._super().invoke(method).arg(this.onCreateOptionsMenuMenuParam));
    }

    private void setOnOptionsItemSelected() {
        JClass menuItemClass = this.classes().MENU_ITEM;
        if (this.usesActionBarSherlock()) {
            menuItemClass = this.classes().SHERLOCK_MENU_ITEM;
        }
        JMethod method = this.generatedClass.method(1, this.codeModel().BOOLEAN, "onOptionsItemSelected");
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        this.onOptionsItemSelectedItem = method.param(menuItemClass, "item");
        this.onOptionsItemSelectedItemId = methodBody.decl(this.codeModel().INT, "itemId_", this.onOptionsItemSelectedItem.invoke("getItemId"));
        this.onOptionsItemSelectedMiddleBlock = methodBody.block();
        methodBody._return(JExpr.invoke(JExpr._super(), method).arg(this.onOptionsItemSelectedItem));
    }

    private boolean usesActionBarSherlock() {
        return new ActionBarSherlockHelper(new AnnotationHelper(this.processingEnvironment())).usesActionBarSherlock(this);
    }

    @Override
    protected void setFindNativeFragmentById() {
        JMethod method = this.generatedClass.method(4, this.classes().FRAGMENT, "findNativeFragmentById");
        JVar idParam = method.param(this.codeModel().INT, "id");
        JBlock body = method.body();
        body._return(JExpr.invoke("getFragmentManager").invoke("findFragmentById").arg(idParam));
        this.findNativeFragmentById = method;
    }

    @Override
    protected void setFindSupportFragmentById() {
        JMethod method = this.generatedClass.method(4, this.classes().SUPPORT_V4_FRAGMENT, "findSupportFragmentById");
        JVar idParam = method.param(this.codeModel().INT, "id");
        JBlock body = method.body();
        body._return(JExpr.invoke("getSupportFragmentManager").invoke("findFragmentById").arg(idParam));
        this.findSupportFragmentById = method;
    }

    @Override
    protected void setFindNativeFragmentByTag() {
        JMethod method = this.generatedClass.method(4, this.classes().FRAGMENT, "findNativeFragmentByTag");
        JVar tagParam = method.param(this.classes().STRING, "tag");
        JBlock body = method.body();
        body._return(JExpr.invoke("getFragmentManager").invoke("findFragmentByTag").arg(tagParam));
        this.findNativeFragmentByTag = method;
    }

    @Override
    protected void setFindSupportFragmentByTag() {
        JMethod method = this.generatedClass.method(4, this.classes().SUPPORT_V4_FRAGMENT, "findSupportFragmentByTag");
        JVar tagParam = method.param(this.classes().STRING, "tag");
        JBlock body = method.body();
        body._return(JExpr.invoke("getSupportFragmentManager").invoke("findFragmentByTag").arg(tagParam));
        this.findSupportFragmentByTag = method;
    }

    public JMethod getSetContentViewLayout() {
        if (this.setContentViewLayout == null) {
            this.setSetContentView();
        }
        return this.setContentViewLayout;
    }

    private void setSetContentView() {
        this.getOnCreate();
        JClass layoutParamsClass = this.classes().VIEW_GROUP_LAYOUT_PARAMS;
        this.setContentViewLayout = this.setContentViewMethod(new JType[]{this.codeModel().INT}, new String[]{"layoutResID"});
        this.setContentViewMethod(new JType[]{this.classes().VIEW, layoutParamsClass}, new String[]{"view", "params"});
        this.setContentViewMethod(new JType[]{this.classes().VIEW}, new String[]{"view"});
    }

    private JMethod setContentViewMethod(JType[] paramTypes, String[] paramNames) {
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "setContentView");
        method.annotate(Override.class);
        ArrayList<JVar> params = new ArrayList<JVar>();
        for (int i = 0; i < paramTypes.length; ++i) {
            JVar param = method.param(paramTypes[i], paramNames[i]);
            params.add(param);
        }
        JBlock body = method.body();
        JInvocation superCall = body.invoke(JExpr._super(), method);
        for (JVar arg : params) {
            superCall.arg(arg);
        }
        this.viewNotifierHelper.invokeViewChanged(body);
        return method;
    }

    public JVar getInitSavedInstanceParam() {
        return this.initSavedInstanceParam;
    }

    private void handleBackPressed() {
        ExecutableElement declaredOnBackPressedMethod = this.getOnBackPressedMethod(this.annotatedElement);
        if (declaredOnBackPressedMethod != null) {
            JMethod onKeyDownMethod = this.generatedClass.method(1, this.codeModel().BOOLEAN, "onKeyDown");
            onKeyDownMethod.annotate(Override.class);
            JVar keyCodeParam = onKeyDownMethod.param(this.codeModel().INT, "keyCode");
            JClass keyEventClass = this.classes().KEY_EVENT;
            JVar eventParam = onKeyDownMethod.param(keyEventClass, "event");
            JClass versionHelperClass = this.refClass(SdkVersionHelper.class);
            JInvocation sdkInt = versionHelperClass.staticInvoke("getSdkInt");
            JBlock onKeyDownBody = onKeyDownMethod.body();
            onKeyDownBody._if(sdkInt.lt(JExpr.lit(5)).cand(keyCodeParam.eq(keyEventClass.staticRef("KEYCODE_BACK"))).cand(eventParam.invoke("getRepeatCount").eq(JExpr.lit(0))))._then().invoke("onBackPressed");
            onKeyDownBody._return(JExpr._super().invoke(onKeyDownMethod).arg(keyCodeParam).arg(eventParam));
        }
    }

    private ExecutableElement getOnBackPressedMethod(TypeElement activityElement) {
        AnnotationHelper annotationHelper = new AnnotationHelper(this.processingEnvironment());
        List<? extends Element> allMembers = annotationHelper.getElementUtils().getAllMembers(activityElement);
        List<ExecutableElement> activityInheritedMethods = ElementFilter.methodsIn(allMembers);
        for (ExecutableElement activityInheritedMethod : activityInheritedMethods) {
            if (!this.isCustomOnBackPressedMethod(activityInheritedMethod)) continue;
            return activityInheritedMethod;
        }
        return null;
    }

    private boolean isCustomOnBackPressedMethod(ExecutableElement method) {
        TypeElement methodClass = (TypeElement)method.getEnclosingElement();
        boolean methodBelongsToActivityClass = methodClass.getQualifiedName().toString().equals("android.app.Activity");
        return !methodBelongsToActivityClass && method.getSimpleName().toString().equals("onBackPressed") && method.getThrownTypes().size() == 0 && method.getModifiers().contains((Object)Modifier.PUBLIC) && method.getReturnType().getKind().equals((Object)TypeKind.VOID) && method.getParameters().size() == 0;
    }

    @Override
    public IntentBuilder getIntentBuilder() {
        return this.intentBuilder;
    }

    @Override
    public void setIntentBuilderClass(JDefinedClass intentBuilderClass) {
        this.intentBuilderClass = intentBuilderClass;
    }

    @Override
    public JDefinedClass getIntentBuilderClass() {
        return this.intentBuilderClass;
    }

    public RoboGuiceHolder getRoboGuiceHolder() {
        if (this.roboGuiceHolder == null) {
            this.roboGuiceHolder = new RoboGuiceHolder(this);
        }
        return this.roboGuiceHolder;
    }

    protected void setScopedObjectsField() {
        JClass keyWildCard = this.classes().KEY.narrow(this.codeModel().wildcard());
        JClass scopedHashMap = this.classes().HASH_MAP.narrow(keyWildCard, this.classes().OBJECT);
        this.getRoboGuiceHolder().scopedObjects = this.getGeneratedClass().field(2, scopedHashMap, "scopedObjects_");
        this.getRoboGuiceHolder().scopedObjects.assign(JExpr._new(scopedHashMap));
    }

    protected void setEventManagerField() {
        this.getRoboGuiceHolder().eventManager = this.generatedClass.field(2, this.classes().EVENT_MANAGER, "eventManager_");
    }

    protected void setContentViewListenerField() {
        this.getRoboGuiceHolder().contentViewListenerField = this.generatedClass.field(0, this.classes().CONTENT_VIEW_LISTENER, "ignored_");
        this.getRoboGuiceHolder().contentViewListenerField.annotate(this.classes().INJECT);
    }

    protected void setScopeField() {
        this.getRoboGuiceHolder().scope = this.getGeneratedClass().field(4, this.classes().CONTEXT_SCOPE, "scope_");
    }

    @Override
    public JMethod getInjectExtrasMethod() {
        if (this.injectExtrasMethod == null) {
            this.setInjectExtras();
        }
        return this.injectExtrasMethod;
    }

    @Override
    public JBlock getInjectExtrasBlock() {
        if (this.injectExtrasBlock == null) {
            this.setInjectExtras();
        }
        return this.injectExtrasBlock;
    }

    @Override
    public JVar getInjectExtras() {
        if (this.injectExtras == null) {
            this.setInjectExtras();
        }
        return this.injectExtras;
    }

    private void setInjectExtras() {
        this.injectExtrasMethod = this.generatedClass.method(4, this.codeModel().VOID, "injectExtras_");
        JBlock injectExtrasBody = this.injectExtrasMethod.body();
        this.injectExtras = injectExtrasBody.decl(this.classes().BUNDLE, "extras_", JExpr.invoke("getIntent").invoke("getExtras"));
        this.injectExtrasBlock = injectExtrasBody._if(this.injectExtras.ne(JExpr._null()))._then();
        this.getSetIntent().body().invoke(this.injectExtrasMethod);
        this.getInitBody().invoke(this.injectExtrasMethod);
    }

    public JMethod getOnNewIntent() {
        if (this.onNewIntentMethod == null) {
            this.setOnNewIntent();
        }
        return this.onNewIntentMethod;
    }

    @Override
    public JBlock getSaveStateMethodBody() {
        return this.instanceStateHolder.getSaveStateMethodBody();
    }

    @Override
    public JVar getSaveStateBundleParam() {
        return this.instanceStateHolder.getSaveStateBundleParam();
    }

    @Override
    public JMethod getRestoreStateMethod() {
        return this.instanceStateHolder.getRestoreStateMethod();
    }

    @Override
    public JVar getRestoreStateBundleParam() {
        return this.instanceStateHolder.getRestoreStateBundleParam();
    }

    @Override
    public JBlock getOnCreateOptionsMenuMethodBody() {
        if (this.onCreateOptionsMenuMethodBody == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMethodBody;
    }

    @Override
    public JVar getOnCreateOptionsMenuMenuInflaterVar() {
        if (this.onCreateOptionsMenuMenuInflaterVar == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMenuInflaterVar;
    }

    @Override
    public JVar getOnCreateOptionsMenuMenuParam() {
        if (this.onCreateOptionsMenuMenuParam == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMenuParam;
    }

    @Override
    public JVar getOnOptionsItemSelectedItem() {
        if (this.onOptionsItemSelectedItem == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedItem;
    }

    @Override
    public JVar getOnOptionsItemSelectedItemId() {
        if (this.onOptionsItemSelectedItemId == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedItemId;
    }

    @Override
    public JBlock getOnOptionsItemSelectedMiddleBlock() {
        if (this.onOptionsItemSelectedMiddleBlock == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedMiddleBlock;
    }

    public NonConfigurationHolder getNonConfigurationHolder() throws JClassAlreadyExistsException {
        if (this.nonConfigurationHolder == null) {
            this.setNonConfigurationHolder();
        }
        return this.nonConfigurationHolder;
    }

    private void setNonConfigurationHolder() throws JClassAlreadyExistsException {
        this.nonConfigurationHolder = new NonConfigurationHolder(this);
    }

    public JBlock getInitIfNonConfigurationNotNullBlock() throws JClassAlreadyExistsException {
        if (this.initIfNonConfigurationNotNullBlock == null) {
            this.setInitNonConfigurationInstance();
        }
        return this.initIfNonConfigurationNotNullBlock;
    }

    public JVar getInitNonConfigurationInstance() throws JClassAlreadyExistsException {
        if (this.initNonConfigurationInstance == null) {
            this.setInitNonConfigurationInstance();
        }
        return this.initNonConfigurationInstance;
    }

    private void setInitNonConfigurationInstance() throws JClassAlreadyExistsException {
        JBlock initBody = this.getInitBody();
        JDefinedClass ncHolderClass = this.getNonConfigurationHolder().getGeneratedClass();
        this.initNonConfigurationInstance = initBody.decl(ncHolderClass, "nonConfigurationInstance", JExpr.cast(ncHolderClass, JExpr._super().invoke(this.getGetLastNonConfigurationInstance())));
        this.initIfNonConfigurationNotNullBlock = initBody._if(this.initNonConfigurationInstance.ne(JExpr._null()))._then();
    }

    public JMethod getGetLastNonConfigurationInstance() throws JClassAlreadyExistsException {
        if (this.getLastNonConfigurationInstance == null) {
            this.setGetLastNonConfigurationInstance();
        }
        return this.getLastNonConfigurationInstance;
    }

    private void setGetLastNonConfigurationInstance() throws JClassAlreadyExistsException {
        AnnotationHelper annotationHelper = new AnnotationHelper(this.processingEnvironment());
        TypeElement fragmentActivityTypeElement = annotationHelper.typeElementFromQualifiedName("android.support.v4.app.FragmentActivity");
        TypeElement typeElement = annotationHelper.typeElementFromQualifiedName(this.generatedClass._extends().fullName());
        String getLastNonConfigurationInstanceName = "getLastNonConfigurationInstance";
        if (fragmentActivityTypeElement != null && annotationHelper.isSubtype(typeElement.asType(), fragmentActivityTypeElement.asType())) {
            getLastNonConfigurationInstanceName = "getLastCustomNonConfigurationInstance";
        }
        NonConfigurationHolder ncHolder = this.getNonConfigurationHolder();
        JDefinedClass ncHolderClass = ncHolder.getGeneratedClass();
        JFieldVar superNonConfigurationInstanceField = ncHolder.getSuperNonConfigurationInstanceField();
        this.getLastNonConfigurationInstance = this.generatedClass.method(1, Object.class, getLastNonConfigurationInstanceName);
        this.getLastNonConfigurationInstance.annotate(Override.class);
        JBlock body = this.getLastNonConfigurationInstance.body();
        JVar nonConfigurationInstance = body.decl(ncHolderClass, "nonConfigurationInstance", JExpr.cast(ncHolderClass, JExpr._super().invoke(this.getLastNonConfigurationInstance)));
        body._if(nonConfigurationInstance.eq(JExpr._null()))._then()._return(JExpr._null());
        body._return(nonConfigurationInstance.ref(superNonConfigurationInstanceField));
    }

    public JBlock getOnRetainNonConfigurationInstanceBindBlock() throws JClassAlreadyExistsException {
        if (this.onRetainNonConfigurationInstanceBindBlock == null) {
            this.setOnRetainNonConfigurationInstance();
        }
        return this.onRetainNonConfigurationInstanceBindBlock;
    }

    public JVar getOnRetainNonConfigurationInstance() throws JClassAlreadyExistsException {
        if (this.onRetainNonConfigurationInstance == null) {
            this.setOnRetainNonConfigurationInstance();
        }
        return this.onRetainNonConfigurationInstance;
    }

    private void setOnRetainNonConfigurationInstance() throws JClassAlreadyExistsException {
        AnnotationHelper annotationHelper = new AnnotationHelper(this.processingEnvironment());
        TypeElement fragmentActivityTypeElement = annotationHelper.typeElementFromQualifiedName("android.support.v4.app.FragmentActivity");
        TypeElement typeElement = annotationHelper.typeElementFromQualifiedName(this.generatedClass._extends().fullName());
        String onRetainNonConfigurationInstanceName = "onRetainNonConfigurationInstance";
        if (fragmentActivityTypeElement != null && annotationHelper.isSubtype(typeElement.asType(), fragmentActivityTypeElement.asType())) {
            onRetainNonConfigurationInstanceName = "onRetainCustomNonConfigurationInstance";
        }
        NonConfigurationHolder ncHolder = this.getNonConfigurationHolder();
        JDefinedClass ncHolderClass = ncHolder.getGeneratedClass();
        JMethod onRetainNonConfigurationInstanceMethod = this.generatedClass.method(1, ncHolderClass, onRetainNonConfigurationInstanceName);
        onRetainNonConfigurationInstanceMethod.annotate(Override.class);
        JBlock methodBody = onRetainNonConfigurationInstanceMethod.body();
        this.onRetainNonConfigurationInstance = methodBody.decl(ncHolderClass, "nonConfigurationInstanceState_", JExpr._new(ncHolderClass));
        JInvocation superCall = JExpr._super().invoke(onRetainNonConfigurationInstanceMethod);
        methodBody.assign(this.onRetainNonConfigurationInstance.ref(ncHolder.getSuperNonConfigurationInstanceField()), superCall);
        this.onRetainNonConfigurationInstanceBindBlock = methodBody.block();
        methodBody._return(this.onRetainNonConfigurationInstance);
    }

    @Override
    public JBlock getOnActivityResultCaseBlock(int requestCode) {
        return this.onActivityResultHolder.getCaseBlock(requestCode);
    }

    @Override
    public JVar getOnActivityResultDataParam() {
        return this.onActivityResultHolder.getDataParam();
    }

    @Override
    public JVar getOnActivityResultResultCodeParam() {
        return this.onActivityResultHolder.getResultCodeParam();
    }

    public JBlock getOnActivityResultAfterSuperBlock() {
        return this.onActivityResultHolder.getAfterSuperBlock();
    }

    public JVar getOnActivityResultRequestCodeParam() {
        return this.onActivityResultHolder.getRequestCodeParam();
    }

    @Override
    public JMethod getOnActivityResultMethod() {
        return this.onActivityResultHolder.getMethod();
    }

    public JBlock getOnDestroyAfterSuperBlock() {
        if (this.onDestroyAfterSuperBlock == null) {
            this.setOnDestroy();
        }
        return this.onDestroyAfterSuperBlock;
    }

    @Override
    public JBlock getOnResumeAfterSuperBlock() {
        if (this.onResumeAfterSuperBlock == null) {
            this.setOnResume();
        }
        return this.onResumeAfterSuperBlock;
    }

    @Override
    public JBlock getOnCreateAfterSuperBlock() {
        return this.getInitBody();
    }

    @Override
    public JBlock getOnDestroyBeforeSuperBlock() {
        if (this.onDestroyBeforeSuperBlock == null) {
            this.setOnDestroy();
        }
        return this.onDestroyBeforeSuperBlock;
    }

    @Override
    public JBlock getOnStartAfterSuperBlock() {
        if (this.onStartAfterSuperBlock == null) {
            this.setOnStart();
        }
        return this.onStartAfterSuperBlock;
    }

    @Override
    public JBlock getOnStopBeforeSuperBlock() {
        if (this.onStopBeforeSuperBlock == null) {
            this.setOnStop();
        }
        return this.onStopBeforeSuperBlock;
    }

    @Override
    public JBlock getOnPauseBeforeSuperBlock() {
        if (this.onPauseBeforeSuperBlock == null) {
            this.setOnPause();
        }
        return this.onPauseBeforeSuperBlock;
    }

    @Override
    public JBlock getOnAttachAfterSuperBlock() {
        return this.receiverRegistrationHolder.getOnAttachAfterSuperBlock();
    }

    @Override
    public JBlock getOnDetachBeforeSuperBlock() {
        return this.receiverRegistrationHolder.getOnDetachBeforeSuperBlock();
    }

    @Override
    public JFieldVar getIntentFilterField(ReceiverRegistrationHolder.IntentFilterData intentFilterData) {
        return this.receiverRegistrationHolder.getIntentFilterField(intentFilterData);
    }

    @Override
    public JBlock getIntentFilterInitializationBlock(ReceiverRegistrationHolder.IntentFilterData intentFilterData) {
        return this.getInitBody();
    }

    @Override
    protected JFieldVar setDatabaseHelperRef(TypeMirror databaseHelperTypeMirror) {
        JFieldVar databaseHelperRef = super.setDatabaseHelperRef(databaseHelperTypeMirror);
        OrmLiteHelper.injectReleaseInDestroy(databaseHelperRef, this, this.classes());
        return databaseHelperRef;
    }

    @Override
    public JBlock getPreferenceScreenInitializationBlock() {
        return this.getInitBody();
    }

    @Override
    public JBlock getAddPreferencesFromResourceBlock() {
        return this.preferencesHolder.getAddPreferencesFromResourceBlock();
    }

    @Override
    public void assignFindPreferenceByKey(JFieldRef idRef, JClass preferenceClass, JFieldRef fieldRef) {
        this.preferencesHolder.assignFindPreferenceByKey(idRef, preferenceClass, fieldRef);
    }

    @Override
    public FoundPreferenceHolder getFoundPreferenceHolder(JFieldRef idRef, JClass preferenceClass) {
        return this.preferencesHolder.getFoundPreferenceHolder(idRef, preferenceClass);
    }

    @Override
    public JBlock getOnBuildHeadersBlock() {
        return this.preferencesHolder.getOnBuildHeadersBlock();
    }

    @Override
    public JVar getOnBuildHeadersTargetParam() {
        return this.preferencesHolder.getOnBuildHeadersTargetParam();
    }
}

