/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.process.ProcessHolder;

public class EBeanHolder
extends EComponentWithViewSupportHolder {
    public static final String GET_INSTANCE_METHOD_NAME = "getInstance_";
    private JFieldVar contextField;
    private JMethod constructor;

    public EBeanHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        super(processHolder, annotatedElement);
        this.setConstructor();
    }

    private void setConstructor() {
        this.constructor = this.generatedClass.constructor(4);
        JVar constructorContextParam = this.constructor.param(this.classes().CONTEXT, "context");
        JBlock constructorBody = this.constructor.body();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(this.annotatedElement.getEnclosedElements());
        ExecutableElement superConstructor = constructors.get(0);
        if (superConstructor.getParameters().size() == 1) {
            constructorBody.invoke("super").arg(constructorContextParam);
        }
        constructorBody.assign(this.getContextField(), constructorContextParam);
    }

    public JFieldVar getContextField() {
        if (this.contextField == null) {
            this.contextField = this.generatedClass.field(4, this.classes().CONTEXT, "context_");
        }
        return this.contextField;
    }

    @Override
    protected void setContextRef() {
        this.contextRef = this.getContextField();
    }

    @Override
    protected void setInit() {
        this.init = this.generatedClass.method(4, this.processHolder.codeModel().VOID, "init_");
    }

    public void invokeInitInConstructor() {
        JBlock constructorBody = this.constructor.body();
        constructorBody.invoke(this.getInit());
    }

    public void createFactoryMethod(boolean hasSingletonScope) {
        JMethod factoryMethod = this.generatedClass.method(17, this.generatedClass, GET_INSTANCE_METHOD_NAME);
        JVar factoryMethodContextParam = factoryMethod.param(this.classes().CONTEXT, "context");
        JBlock factoryMethodBody = factoryMethod.body();
        if (hasSingletonScope) {
            JFieldVar instanceField = this.generatedClass.field(20, this.generatedClass, "instance_");
            JBlock creationBlock = factoryMethodBody._if(instanceField.eq(JExpr._null()))._then();
            JVar previousNotifier = this.viewNotifierHelper.replacePreviousNotifierWithNull(creationBlock);
            creationBlock.assign(instanceField, JExpr._new(this.generatedClass).arg(factoryMethodContextParam.invoke("getApplicationContext")));
            creationBlock.invoke((JExpression)instanceField, this.getInit());
            this.viewNotifierHelper.resetPreviousNotifier(creationBlock, previousNotifier);
            factoryMethodBody._return(instanceField);
        } else {
            factoryMethodBody._return(JExpr._new(this.generatedClass).arg(factoryMethodContextParam));
        }
    }

    public void createRebindMethod() {
        JMethod rebindMethod = this.generatedClass.method(1, this.codeModel().VOID, "rebind");
        JVar contextParam = rebindMethod.param(this.classes().CONTEXT, "context");
        JBlock body = rebindMethod.body();
        body.assign(this.getContextField(), contextParam);
        body.invoke(this.getInit());
    }
}

