/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.FoundPreferenceHolder;
import org.androidannotations.holder.GeneratedClassHolderDecorator;
import org.androidannotations.holder.HasPreferences;
import org.androidannotations.process.ProcessHolder;

public class PreferencesHolder
extends GeneratedClassHolderDecorator<EComponentWithViewSupportHolder>
implements HasPreferences {
    private APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    protected JBlock addPreferencesFromResourceBlock;

    public PreferencesHolder(EComponentWithViewSupportHolder holder) {
        super(holder);
    }

    @Override
    public JDefinedClass getGeneratedClass() {
        return ((EComponentWithViewSupportHolder)this.holder).getGeneratedClass();
    }

    @Override
    public TypeElement getAnnotatedElement() {
        return ((EComponentWithViewSupportHolder)this.holder).getAnnotatedElement();
    }

    @Override
    public ProcessingEnvironment processingEnvironment() {
        return ((EComponentWithViewSupportHolder)this.holder).processingEnvironment();
    }

    @Override
    public ProcessHolder.Classes classes() {
        return ((EComponentWithViewSupportHolder)this.holder).classes();
    }

    @Override
    public JCodeModel codeModel() {
        return ((EComponentWithViewSupportHolder)this.holder).codeModel();
    }

    @Override
    public JClass refClass(String fullyQualifiedClassName) {
        return ((EComponentWithViewSupportHolder)this.holder).refClass(fullyQualifiedClassName);
    }

    @Override
    public JClass refClass(Class<?> clazz) {
        return this.refClass(clazz);
    }

    @Override
    public JDefinedClass definedClass(String fullyQualifiedClassName) {
        return this.definedClass(fullyQualifiedClassName);
    }

    @Override
    public JBlock getAddPreferencesFromResourceBlock() {
        if (this.addPreferencesFromResourceBlock == null) {
            this.setAddPreferencesFromResourceBlock();
        }
        return this.addPreferencesFromResourceBlock;
    }

    private void setAddPreferencesFromResourceBlock() {
        JMethod method = this.getGeneratedClass().method(1, this.codeModel().VOID, "addPreferencesFromResource");
        method.annotate(Override.class);
        JVar preferencesResIdParam = method.param(Integer.TYPE, "preferencesResId");
        method.body().invoke(JExpr._super(), "addPreferencesFromResource").arg(preferencesResIdParam);
        this.addPreferencesFromResourceBlock = method.body();
    }

    private JInvocation findPreferenceByKey(JFieldRef idRef) {
        JInvocation getString = JExpr.invoke(JExpr._this(), "getString").arg(idRef);
        JInvocation findPreferenceByKey = JExpr.invoke(JExpr._this(), "findPreference");
        return findPreferenceByKey.arg(getString);
    }

    @Override
    public void assignFindPreferenceByKey(JFieldRef idRef, JClass preferenceClass, JFieldRef fieldRef) {
        JExpression assignExpression;
        String idRefString = this.codeModelHelper.getIdStringFromIdFieldRef(idRef);
        FoundPreferenceHolder foundViewHolder = (FoundPreferenceHolder)((EComponentWithViewSupportHolder)this.holder).foundHolders.get(idRefString);
        JBlock block = this.getAddPreferencesFromResourceBlock();
        if (foundViewHolder != null) {
            assignExpression = foundViewHolder.getOrCastRef(preferenceClass);
        } else {
            assignExpression = this.findPreferenceByKey(idRef);
            if (preferenceClass != null && preferenceClass != this.classes().PREFERENCE) {
                assignExpression = JExpr.cast(preferenceClass, assignExpression);
            }
            ((EComponentWithViewSupportHolder)this.holder).foundHolders.put(idRefString, new FoundPreferenceHolder(this, preferenceClass, fieldRef, block));
        }
        block.assign(fieldRef, assignExpression);
    }

    @Override
    public FoundPreferenceHolder getFoundPreferenceHolder(JFieldRef idRef, JClass preferenceClass) {
        String idRefString = this.codeModelHelper.getIdStringFromIdFieldRef(idRef);
        FoundPreferenceHolder foundPreferenceHolder = (FoundPreferenceHolder)((EComponentWithViewSupportHolder)this.holder).foundHolders.get(idRefString);
        if (foundPreferenceHolder == null) {
            foundPreferenceHolder = this.createFoundPreferenceAndIfNotNullBlock(idRef, preferenceClass);
            ((EComponentWithViewSupportHolder)this.holder).foundHolders.put(idRefString, foundPreferenceHolder);
        }
        return foundPreferenceHolder;
    }

    private FoundPreferenceHolder createFoundPreferenceAndIfNotNullBlock(JFieldRef idRef, JClass preferenceClass) {
        JExpressionImpl findPreferenceExpression = this.findPreferenceByKey(idRef);
        JBlock block = this.getAddPreferencesFromResourceBlock().block();
        if (preferenceClass == null) {
            preferenceClass = this.classes().PREFERENCE;
        } else if (preferenceClass != this.classes().PREFERENCE) {
            findPreferenceExpression = JExpr.cast(preferenceClass, findPreferenceExpression);
        }
        JVar preference = block.decl(preferenceClass, "preference", findPreferenceExpression);
        return new FoundPreferenceHolder(this, preferenceClass, preference, block);
    }

    @Override
    public JBlock getPreferenceScreenInitializationBlock() {
        throw new UnsupportedOperationException();
    }
}

