/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.fastagi.AgiServer;
import org.asteriskjava.fastagi.ClassNameMappingStrategy;
import org.asteriskjava.fastagi.CompositeMappingStrategy;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.ResourceBundleMappingStrategy;
import org.asteriskjava.fastagi.internal.AgiConnectionHandler;
import org.asteriskjava.util.DaemonThreadFactory;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ServerSocketFacade;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.ServerSocketFacadeImpl;

public class DefaultAgiServer
implements AgiServer {
    private static final String DEFAULT_CONFIG_RESOURCE_BUNDLE_NAME = "fastagi";
    private static final int DEFAULT_BIND_PORT = 4573;
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 100;
    private final Log logger = LogFactory.getLog(DefaultAgiServer.class);
    private ServerSocketFacade serverSocket;
    private int port = 4573;
    private ThreadPoolExecutor pool;
    private int poolSize = 10;
    private int maximumPoolSize = this.poolSize;
    private boolean die;
    private MappingStrategy mappingStrategy = new CompositeMappingStrategy(new ResourceBundleMappingStrategy(), new ClassNameMappingStrategy());

    public DefaultAgiServer() {
        this.loadConfig();
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setBindPort(int bindPort) {
        this.port = bindPort;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMappingStrategy(MappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    private void loadConfig() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(DEFAULT_CONFIG_RESOURCE_BUNDLE_NAME);
        }
        catch (MissingResourceException e) {
            return;
        }
        try {
            String portString = resourceBundle.getString("port");
            if (portString == null) {
                portString = resourceBundle.getString("bindPort");
            }
            this.port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String poolSizeString = resourceBundle.getString("poolSize");
            this.poolSize = Integer.parseInt(poolSizeString);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String maximumPoolSizeString = resourceBundle.getString("maximumPoolSize");
            this.maximumPoolSize = Integer.parseInt(maximumPoolSizeString);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ServerSocketFacade createServerSocket() throws IOException {
        return new ServerSocketFacadeImpl(this.port, 0, null);
    }

    public void startup() throws IOException, IllegalStateException {
        this.die = false;
        this.pool = new ThreadPoolExecutor(this.poolSize, this.maximumPoolSize < this.poolSize ? this.poolSize : this.maximumPoolSize, 50000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory());
        this.logger.info("Thread pool started.");
        try {
            this.serverSocket = this.createServerSocket();
        }
        catch (IOException e) {
            this.logger.error("Unable start AgiServer: cannot to bind to *:" + this.port + ".", e);
            throw e;
        }
        this.logger.info("Listening on *:" + this.port + ".");
        while (true) {
            try {
                while (true) {
                    SocketConnectionFacade socket = this.serverSocket.accept();
                    this.logger.info("Received connection from " + socket.getRemoteAddress());
                    AgiConnectionHandler connectionHandler = new AgiConnectionHandler(socket, this.mappingStrategy);
                    this.pool.execute(connectionHandler);
                }
            }
            catch (IOException e) {
                if (!this.die) {
                    this.logger.error("IOException while waiting for connections.", e);
                    continue;
                }
                this.logger.info("AgiServer shut down.");
                return;
            }
            break;
        }
    }

    public void run() {
        try {
            this.startup();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void die() {
        this.die = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                this.logger.warn("IOException while closing server socket.", e);
            }
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    public void shutdown() throws IllegalStateException {
        this.die();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.pool != null) {
            this.pool.shutdown();
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws Exception {
        DefaultAgiServer server = new DefaultAgiServer();
        server.startup();
    }
}

