/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.ProtocolIdentifierReceivedEvent;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.internal.EventBuilder;
import org.asteriskjava.manager.internal.EventBuilderImpl;
import org.asteriskjava.manager.internal.ManagerReader;
import org.asteriskjava.manager.internal.ResponseBuilder;
import org.asteriskjava.manager.internal.ResponseBuilderImpl;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerReaderImpl
implements ManagerReader {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final EventBuilder eventBuilder;
    private final ResponseBuilder responseBuilder;
    private final Dispatcher dispatcher;
    private final Object source;
    private SocketConnectionFacade socket;
    private boolean die = false;
    private boolean dead = false;
    private IOException terminationException;

    public ManagerReaderImpl(Dispatcher dispatcher, Object source) {
        this.dispatcher = dispatcher;
        this.source = source;
        this.eventBuilder = new EventBuilderImpl();
        this.responseBuilder = new ResponseBuilderImpl();
    }

    @Override
    public void setSocket(SocketConnectionFacade socket) {
        this.socket = socket;
    }

    @Override
    public void registerEventClass(Class eventClass) {
        this.eventBuilder.registerEventClass(eventClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashMap<String, String> buffer = new HashMap<String, String>();
        ArrayList<String> commandResult = new ArrayList<String>();
        boolean processingCommandResult = false;
        if (this.socket == null) {
            throw new IllegalStateException("Unable to run: socket is null.");
        }
        this.die = false;
        this.dead = false;
        try {
            String line;
            while ((line = this.socket.readLine()) != null && !this.die) {
                if (processingCommandResult) {
                    if ("--END COMMAND--".equals(line) || " --END COMMAND--".equals(line)) {
                        CommandResponse commandResponse = new CommandResponse();
                        for (int crIdx = 0; crIdx < commandResult.size(); ++crIdx) {
                            String[] crNVPair = ((String)commandResult.get(crIdx)).split(" *: *", 2);
                            if (crNVPair[0].equalsIgnoreCase("ActionID")) {
                                commandResult.remove(crIdx--);
                                commandResponse.setActionId(crNVPair[1]);
                                continue;
                            }
                            if (!crNVPair[0].equalsIgnoreCase("Privilege")) break;
                            commandResult.remove(crIdx--);
                        }
                        commandResponse.setResponse("Follows");
                        commandResponse.setDateReceived(DateUtil.getDate());
                        commandResponse.setResult(new ArrayList<String>(commandResult));
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put("actionid", commandResponse.getActionId());
                        attributes.put("response", commandResponse.getResponse());
                        commandResponse.setAttributes(attributes);
                        this.dispatcher.dispatchResponse(commandResponse);
                        processingCommandResult = false;
                        continue;
                    }
                    commandResult.add(line);
                    continue;
                }
                if ("Response: Follows".equalsIgnoreCase(line)) {
                    processingCommandResult = true;
                    commandResult.clear();
                    continue;
                }
                if (line.startsWith("Asterisk Call Manager/") || line.startsWith("Asterisk Manager Proxy/")) {
                    ProtocolIdentifierReceivedEvent protocolIdentifierReceivedEvent = new ProtocolIdentifierReceivedEvent(this.source);
                    protocolIdentifierReceivedEvent.setProtocolIdentifier(line);
                    protocolIdentifierReceivedEvent.setDateReceived(DateUtil.getDate());
                    this.dispatcher.dispatchEvent(protocolIdentifierReceivedEvent);
                    continue;
                }
                if (line.length() == 0) {
                    if (buffer.containsKey("event")) {
                        ManagerEvent event = this.buildEvent(this.source, buffer);
                        if (event != null) {
                            this.dispatcher.dispatchEvent(event);
                        } else {
                            this.logger.debug("buildEvent returned null");
                        }
                    } else if (buffer.containsKey("response")) {
                        ManagerResponse response = this.buildResponse(buffer);
                        if (response != null) {
                            this.dispatcher.dispatchResponse(response);
                        }
                    } else if (buffer.size() > 0) {
                        this.logger.debug("buffer contains neither response nor event");
                    }
                    buffer.clear();
                    continue;
                }
                int delimiterIndex = line.indexOf(":");
                if (delimiterIndex <= 0 || line.length() <= delimiterIndex + 2) continue;
                String name = line.substring(0, delimiterIndex).toLowerCase(Locale.ENGLISH);
                String value = line.substring(delimiterIndex + 2);
                buffer.put(name, value);
            }
            this.dead = true;
            this.logger.debug("Reached end of stream, terminating reader.");
        }
        catch (IOException e) {
            this.terminationException = e;
            this.dead = true;
            this.logger.info("Terminating reader thread: " + e.getMessage());
        }
        finally {
            this.dead = true;
            DisconnectEvent disconnectEvent = new DisconnectEvent(this.source);
            disconnectEvent.setDateReceived(DateUtil.getDate());
            this.dispatcher.dispatchEvent(disconnectEvent);
        }
    }

    @Override
    public void die() {
        this.die = true;
    }

    @Override
    public boolean isDead() {
        return this.dead;
    }

    @Override
    public IOException getTerminationException() {
        return this.terminationException;
    }

    private ManagerResponse buildResponse(Map<String, String> buffer) {
        ManagerResponse response = this.responseBuilder.buildResponse(buffer);
        if (response != null) {
            response.setDateReceived(DateUtil.getDate());
        }
        return response;
    }

    private ManagerEvent buildEvent(Object source, Map<String, String> buffer) {
        ManagerEvent event = this.eventBuilder.buildEvent(source, buffer);
        if (event != null) {
            event.setDateReceived(DateUtil.getDate());
        }
        return event;
    }
}

