/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ChannelHangupListener;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.InvalidChannelName;
import org.asteriskjava.pbx.agi.AgiChannelActivityHold;
import org.asteriskjava.pbx.internal.core.ChannelImpl;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class ChannelProxy
implements Channel,
ChannelHangupListener {
    private static final Log logger = LogFactory.getLog(ChannelProxy.class);
    private static final AtomicInteger _nextIdentity = new AtomicInteger();
    private int _identity = _nextIdentity.incrementAndGet();
    private ChannelImpl _channel;
    private List<ChannelHangupListener> listeners = new CopyOnWriteArrayList<ChannelHangupListener>();
    private AtomicReference<AgiChannelActivityAction> currentActivityAction = new AtomicReference();
    private volatile boolean isInAgi;
    final CountDownLatch hasReachedAgi = new CountDownLatch(1);

    public ChannelProxy(ChannelImpl channel) {
        this._channel = channel;
        this.currentActivityAction.set(new AgiChannelActivityHold());
        channel.addHangupListener(this);
    }

    public Channel getChannel() {
        return this._channel;
    }

    @Override
    public boolean isSame(Channel rhs) {
        return this._channel.isSame(rhs);
    }

    @Override
    public boolean isSame(String extendedChannelName, String uniqueID) {
        return this._channel.isSame(extendedChannelName, uniqueID);
    }

    public boolean sameUniqueID(String uniqueID) {
        return this._channel.sameUniqueID(uniqueID);
    }

    @Override
    public boolean sameEndPoint(Channel rhs) {
        return this._channel.sameEndPoint(rhs);
    }

    @Override
    public boolean sameEndPoint(EndPoint extensionRoaming) {
        return this._channel.sameEndPoint(extensionRoaming);
    }

    @Override
    public boolean sameExtenededChannelName(String channelName) {
        return this._channel.sameExtenededChannelName(channelName);
    }

    @Override
    public void setParked(boolean parked) {
        this._channel.setParked(parked);
    }

    @Override
    public void setMute(boolean muteState) {
        this._channel.setMute(muteState);
    }

    @Override
    public long getChannelId() {
        return this._channel.getChannelId();
    }

    @Override
    public boolean isLive() {
        return this._channel.isLive();
    }

    @Override
    public void addHangupListener(ChannelHangupListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(ChannelHangupListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isConnectedTo(EndPoint endPoint) {
        return this._channel.isConnectedTo(endPoint);
    }

    @Override
    public String getChannelName() {
        return this._channel.getChannelName();
    }

    @Override
    public EndPoint getEndPoint() {
        return this._channel.getEndPoint();
    }

    @Override
    public boolean isMute() {
        return this._channel.isMute();
    }

    @Override
    public boolean isLocal() {
        return this._channel.isLocal();
    }

    @Override
    public boolean isZombie() {
        return this._channel.isZombie();
    }

    @Override
    public boolean isConsole() {
        return this._channel.isConsole();
    }

    @Override
    public CallerID getCallerID() {
        return this._channel.getCallerID();
    }

    @Override
    public void rename(String newName, String uniqueId) throws InvalidChannelName {
        this._channel.rename(newName, uniqueId);
    }

    @Override
    public boolean isParked() {
        return this._channel.isParked();
    }

    public void masquerade(ChannelProxy cloneProxy) throws InvalidChannelName {
        ChannelImpl originalChannel = this._channel;
        ChannelImpl cloneChannel = cloneProxy._channel;
        cloneChannel.masquerade(this._channel);
        originalChannel.removeListener(this);
        cloneChannel.removeListener(cloneProxy);
        this._channel = cloneChannel;
        cloneProxy._channel = originalChannel;
        this._channel.addHangupListener(this);
        cloneProxy._channel.addHangupListener(cloneProxy);
        logger.debug(originalChannel + " Channel proxy now points to " + this._channel);
    }

    public ChannelImpl getRealChannel() {
        return this._channel;
    }

    @Override
    public String getExtendedChannelName() {
        return this._channel.getExtendedChannelName();
    }

    @Override
    public void notifyHangupListeners(Integer cause, String causeText) {
        for (ChannelHangupListener listener : this.listeners) {
            listener.channelHangup(this, cause, causeText);
        }
    }

    public String toString() {
        return "(proxy=" + this._identity + ") " + this._channel.toString();
    }

    @Override
    public void channelHangup(Channel channel, Integer cause, String causeText) {
        if (channel == this._channel) {
            this.notifyHangupListeners(cause, causeText);
        }
    }

    @Override
    public boolean canDetectHangup() {
        return this._channel.canDetectHangup();
    }

    @Override
    public boolean isQuiescent() {
        return this._channel.isQuiescent();
    }

    @Override
    public boolean hasCallerID() {
        return this._channel.hasCallerID();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._identity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelProxy)) {
            return false;
        }
        ChannelProxy other = (ChannelProxy)obj;
        return this._identity == other._identity;
    }

    @Override
    public AgiChannelActivityAction getCurrentActivityAction() {
        return this.currentActivityAction.get();
    }

    @Override
    public void setCurrentActivityAction(AgiChannelActivityAction action) {
        AgiChannelActivityAction previousAction = this.currentActivityAction.get();
        logger.debug("Setting action to " + action.getClass().getSimpleName() + " for " + this);
        this.currentActivityAction.set(action);
        if (previousAction != null) {
            previousAction.cancel(this);
        }
    }

    @Override
    public void setIsInAgi(boolean b) {
        if (b) {
            this.hasReachedAgi.countDown();
        }
        this.isInAgi = b;
        logger.debug("Setting is in agi to " + b + " for channel " + this);
    }

    @Override
    public boolean isInAgi() {
        return this.isInAgi;
    }

    @Override
    public boolean waitForChannelToReachAgi(long timeout, TimeUnit timeunit) throws InterruptedException {
        return this.hasReachedAgi.await(timeout, timeunit);
    }

    @Override
    public String getUniqueId() {
        return this._channel.getUniqueId();
    }

    public int getIdentity() {
        return this._identity;
    }

    @Override
    public void setCallerId(CallerID callerId) {
        this._channel.setCallerId(callerId);
    }
}

