/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.pbx.Activity;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.ActivityStatusEnum;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.GetVarAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.OriginateAction;
import org.asteriskjava.pbx.asterisk.wrap.events.HangupEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.OriginateResponseEvent;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.EventListenerBaseClass;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class DialLocalToAgiActivity
extends EventListenerBaseClass
implements Runnable,
Activity {
    private EndPoint from;
    private CallerID fromCallerID;
    private Thread thread;
    private final Log logger = LogFactory.getLog(this.getClass());
    private String originateId;
    CountDownLatch latch = new CountDownLatch(1);
    private List<Channel> channels = new LinkedList<Channel>();
    private ActivityCallback<DialLocalToAgiActivity> callback;
    private Map<String, String> channelVarsToSet;

    public DialLocalToAgiActivity(EndPoint from, CallerID fromCallerID, ActivityCallback<DialLocalToAgiActivity> callback, Map<String, String> channelVarsToSet) {
        super("Dial " + from + " to AGI");
        this.from = from;
        this.fromCallerID = fromCallerID;
        this.callback = callback;
        this.channelVarsToSet = channelVarsToSet;
        this.startListener(PBXFactory.getActivePBX());
        this.thread = new Thread((Runnable)this, "Dial " + from + " to AGI");
        this.thread.start();
    }

    @Override
    public void run() {
        this.logger.debug("*******************************************************************************");
        this.logger.info("***********                    begin dial local to AGI                  ****************");
        this.logger.debug("***********                                                      ****************");
        this.logger.debug("*******************************************************************************");
        AsteriskSettings settings = PBXFactory.getActiveProfile();
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        OriginateAction originate = new OriginateAction();
        originate.setEndPoint(this.from);
        originate.setContext(settings.getManagementContext());
        originate.setExten(pbx.getExtensionAgi());
        originate.setPriority(1);
        originate.setCallerId(this.fromCallerID);
        originate.setTimeout(30000L);
        this.originateId = originate.getActionId();
        HashMap<String, String> myVars = new HashMap<String, String>();
        myVars.put("__njrOriginateID", this.originateId);
        if (this.channelVarsToSet != null) {
            myVars.putAll(this.channelVarsToSet);
        }
        originate.setVariables(myVars);
        try {
            pbx.sendAction(originate, 30000);
            this.latch.await(30L, TimeUnit.SECONDS);
            this.callback.progress(this, ActivityStatusEnum.SUCCESS, ActivityStatusEnum.SUCCESS.getDefaultMessage());
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | TimeoutException e) {
            this.logger.error(e, e);
        }
        catch (InterruptedException e) {
            this.logger.error(e, e);
        }
    }

    public void abort(String reason) {
        this.logger.warn("Aborting originate ");
        this.close();
        for (Channel channel : this.channels) {
            PBX pbx = PBXFactory.getActivePBX();
            try {
                pbx.hangup(channel);
            }
            catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                this.logger.error(e, e);
            }
        }
        this.latch.countDown();
    }

    @Override
    public synchronized void onManagerEvent(ManagerEvent event) {
        if (event instanceof HangupEvent) {
            this.close();
        }
        if (event instanceof NewChannelEvent) {
            NewChannelEvent newState = (NewChannelEvent)event;
            Channel channel = newState.getChannel();
            AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
            GetVarAction var = new GetVarAction(channel, "njrOriginateID");
            try {
                if (channel.isLocal()) {
                    int wait = 5;
                    while (wait > 0) {
                        --wait;
                        ManagerResponse response = pbx.sendAction(var, 500);
                        String channelsOriginateId = response.getAttribute("value");
                        if (this.originateId.equalsIgnoreCase(channelsOriginateId)) {
                            this.logger.info("Found the local channel " + channel);
                            this.channels.add(channel);
                            wait = 0;
                            if (this.channels.size() != 2) continue;
                            this.latch.countDown();
                            continue;
                        }
                        if (channelsOriginateId == null || channelsOriginateId.length() == 0) {
                            Thread.sleep(100L);
                            this.logger.error("Waiting for variables on " + channel);
                            continue;
                        }
                        this.logger.error("Didn't match " + channel + " " + channelsOriginateId + "!=" + this.originateId);
                        wait = 0;
                    }
                }
            }
            catch (IOException | IllegalArgumentException | IllegalStateException | TimeoutException e) {
                this.logger.error(e, e);
            }
            catch (InterruptedException e) {
                this.logger.error(e, e);
            }
        }
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(OriginateResponseEvent.class);
        required.add(HangupEvent.class);
        required.add(NewChannelEvent.class);
        return required;
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    @Override
    public Throwable getLastException() {
        return null;
    }

    @Override
    public boolean isSuccess() {
        return this.channels.size() == 2;
    }

    public Channel getChannel1() {
        return this.channels.get(0);
    }

    public Channel getChannel2() {
        return this.channels.get(1);
    }
}

