/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.managerAPI;

import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.core.FilteredManagerListener;

public abstract class EventListenerBaseClass
implements FilteredManagerListener<ManagerEvent>,
AutoCloseable {
    private final String name;

    protected EventListenerBaseClass(String descriptiveName) {
        this.name = descriptiveName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void startListener(PBX iPBX) {
        ((AsteriskPBX)iPBX).addListener(this);
    }

    @Override
    public void close() {
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        pbx.removeListener(this);
    }

    public class AutoClose
    implements AutoCloseable {
        EventListenerBaseClass listener;

        public AutoClose(EventListenerBaseClass listener) {
            this(listener, true);
        }

        public AutoClose(EventListenerBaseClass listener, boolean sendEvents) {
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            this.listener = listener;
            if (sendEvents) {
                listener.startListener(PBXFactory.getActivePBX());
            }
        }

        @Override
        public void close() {
            this.listener.close();
        }
    }
}

