/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;

public class QuercusLanguageException
extends QuercusException {
    private static final StringValue FILE = new StringBuilderValue("file");
    private static final StringValue LINE = new StringBuilderValue("line");
    private static final StringValue MESSAGE = new StringBuilderValue("message");
    private Value _value;

    public QuercusLanguageException(Value value) {
        super(value.toString());
        this._value = value;
    }

    public Value getValue() {
        return this._value;
    }

    public String getMessage(Env env) {
        Value field = this._value.getField(env, MESSAGE);
        if (field != null) {
            return field.toString();
        }
        return "";
    }

    public Location getLocation(Env env) {
        Value file = this._value.getField(env, FILE);
        Value line = this._value.getField(env, LINE);
        if (file.isNull() || line.isNull()) {
            return Location.UNKNOWN;
        }
        return new Location(file.toString(), line.toInt(), null, null);
    }
}

