/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;

public class FloatObjectMarshal
extends Marshal {
    public static final Marshal MARSHAL = new FloatObjectMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return new Float((float)expr.evalDouble(env));
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaFloat();
    }

    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return DoubleValue.ZERO;
        }
        return new DoubleValue(((Number)value).doubleValue());
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof DoubleValue) {
            return 100;
        }
        if (argValue.isLongConvertible()) {
            return 305;
        }
        if (argValue.isDoubleConvertible()) {
            return 304;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return Float.class;
    }
}

