/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.json;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;

class JsonDecoder {
    private static final L10N L = new L10N(JsonDecoder.class);
    private StringValue _string;
    private int _len;
    private int _offset;
    private boolean _isAssociative;

    JsonDecoder() {
    }

    public Value jsonDecode(Env env, StringValue s, boolean assoc) {
        this._string = s;
        this._len = this._string.length();
        this._offset = 0;
        this._isAssociative = assoc;
        Value val = this.jsonDecodeImpl(env);
        if (this.skipWhitespace() >= 0) {
            return this.errorReturn(env, "expected no more input");
        }
        return val;
    }

    private Value jsonDecodeImpl(Env env) {
        int ch = this.skipWhitespace();
        if (ch >= 0) {
            switch (ch) {
                case 34: {
                    return this.decodeString(env);
                }
                case 116: {
                    if (this.read() == 114 && this.read() == 117 && this.read() == 101) {
                        return BooleanValue.TRUE;
                    }
                    return this.errorReturn(env, "expected 'true'");
                }
                case 102: {
                    if (this.read() == 97 && this.read() == 108 && this.read() == 115 && this.read() == 101) {
                        return BooleanValue.FALSE;
                    }
                    return this.errorReturn(env, "expected 'false'");
                }
                case 110: {
                    if (this.read() == 117 && this.read() == 108 && this.read() == 108) {
                        return NullValue.NULL;
                    }
                    return this.errorReturn(env, "expected 'null'");
                }
                case 91: {
                    return this.decodeArray(env);
                }
                case 123: {
                    return this.decodeObject(env);
                }
            }
            if (ch == 45 || 48 <= ch && ch <= 57) {
                return this.decodeNumber(env, ch);
            }
            return this.errorReturn(env);
        }
        return this.errorReturn(env);
    }

    private Value decodeNumber(Env env, int ch) {
        StringBuilder sb = new StringBuilder();
        if (ch == 45) {
            sb.append((char)ch);
            ch = this.read();
        }
        if (ch >= 0) {
            if (ch == 48) {
                sb.append((char)ch);
                ch = this.read();
            } else if (49 <= ch && ch <= 57) {
                sb.append((char)ch);
                ch = this.read();
                while (48 <= ch && ch <= 57) {
                    sb.append((char)ch);
                    ch = this.read();
                }
            } else {
                return this.errorReturn(env, "expected 1-9");
            }
        }
        int integerEnd = sb.length();
        if (ch == 46) {
            sb.append((char)ch);
            ch = this.read();
            while (48 <= ch && ch <= 57) {
                sb.append((char)ch);
                ch = this.read();
            }
        }
        if (ch == 101 || ch == 69) {
            sb.append((char)ch);
            ch = this.read();
            if (ch == 43 || ch == 45) {
                sb.append((char)ch);
                ch = this.read();
            }
            if (48 <= ch && ch <= 57) {
                sb.append((char)ch);
                ch = this.read();
                while (48 <= ch && ch <= 57) {
                    sb.append((char)ch);
                    ch = this.read();
                }
            } else {
                return this.errorReturn(env, "expected 0-9 exponent");
            }
        }
        this.unread();
        if (integerEnd != sb.length()) {
            return new DoubleValue(Double.parseDouble(sb.toString()));
        }
        return new LongValue(Long.parseLong(sb.toString()));
    }

    private Value decodeArray(Env env) {
        int ch;
        ArrayValueImpl array = new ArrayValueImpl();
        while ((ch = this.skipWhitespace()) != 93) {
            this.unread();
            array.append(this.jsonDecodeImpl(env));
            ch = this.skipWhitespace();
            if (ch == 44) continue;
            if (ch == 93) break;
            this.errorReturn(env, "expected either ',' or ']'");
        }
        return array;
    }

    private Value decodeObject(Env env) {
        if (this._isAssociative) {
            return this.decodeObjectToArray(env);
        }
        return this.decodeObjectToObject(env);
    }

    private Value decodeObjectToArray(Env env) {
        int ch;
        ArrayValueImpl array = new ArrayValueImpl();
        while ((ch = this.skipWhitespace()) != 125) {
            this.unread();
            Value name = this.jsonDecodeImpl(env);
            ch = this.skipWhitespace();
            if (ch != 58) {
                return this.errorReturn(env, "expected ':'");
            }
            ((ArrayValue)array).append(name, this.jsonDecodeImpl(env));
            ch = this.skipWhitespace();
            if (ch == 44) continue;
            if (ch == 125) break;
            return this.errorReturn(env, "expected either ',' or '}'");
        }
        return array;
    }

    private Value decodeObjectToObject(Env env) {
        int ch;
        ObjectValue object = env.createObject();
        while ((ch = this.skipWhitespace()) != 125) {
            this.unread();
            Value name = this.jsonDecodeImpl(env);
            ch = this.skipWhitespace();
            if (ch != 58) {
                return this.errorReturn(env, "expected ':'");
            }
            object.putField(env, name.toString(), this.jsonDecodeImpl(env));
            ch = this.skipWhitespace();
            if (ch == 44) continue;
            if (ch == 125) break;
            return this.errorReturn(env, "expected either ',' or '}'");
        }
        return object;
    }

    private Value decodeString(Env env) {
        StringValue sbv = env.createUnicodeBuilder();
        int ch = this.read();
        while (ch >= 0) {
            switch (ch) {
                case 92: {
                    ch = this.read();
                    if (ch < 0) {
                        return this.errorReturn(env, "invalid escape character");
                    }
                    switch (ch) {
                        case 34: {
                            sbv.append('\"');
                            break;
                        }
                        case 92: {
                            sbv.append('\\');
                            break;
                        }
                        case 47: {
                            sbv.append('/');
                            break;
                        }
                        case 98: {
                            sbv.append('\b');
                            break;
                        }
                        case 102: {
                            sbv.append('\f');
                            break;
                        }
                        case 110: {
                            sbv.append('\n');
                            break;
                        }
                        case 114: {
                            sbv.append('\r');
                            break;
                        }
                        case 116: {
                            sbv.append('\t');
                            break;
                        }
                        case 85: 
                        case 117: {
                            int hex = 0;
                            for (int i = 0; i < 4; ++i) {
                                hex <<= 4;
                                ch = this.read();
                                if (48 <= ch && ch <= 57) {
                                    hex += ch - 48;
                                    continue;
                                }
                                if (ch >= 97 && ch <= 102) {
                                    hex += ch - 97 + 10;
                                    continue;
                                }
                                if (ch >= 65 && ch <= 70) {
                                    hex += ch - 65 + 10;
                                    continue;
                                }
                                return this.errorReturn(env, "invalid escaped hex character");
                            }
                            if (hex < 128) {
                                sbv.append((char)hex);
                                break;
                            }
                            if (hex < 2048) {
                                sbv.append((char)(192 + (hex >> 6)));
                                sbv.append((char)(128 + (hex & 0x3F)));
                                break;
                            }
                            sbv.append((char)(224 + (hex >> 12)));
                            sbv.append((char)(128 + (hex >> 6 & 0x3F)));
                            sbv.append((char)(128 + (hex & 0x3F)));
                        }
                    }
                    break;
                }
                case 34: {
                    return sbv;
                }
                default: {
                    sbv.append((char)ch);
                }
            }
            ch = this.read();
        }
        return this.errorReturn(env, "error decoding string");
    }

    private Value errorReturn(Env env) {
        return this.errorReturn(env, null);
    }

    private Value errorReturn(Env env, String message) {
        int end;
        int start;
        if (this._offset < this._len) {
            start = this._offset - 1;
            end = this._offset;
        } else {
            start = this._len - 1;
            end = this._len;
        }
        String token = this._string.substring(start, end).toString();
        if (message != null) {
            env.warning(L.l("error parsing '{0}': {1}", (Object)token, (Object)message));
        } else {
            env.warning(L.l("error parsing '{0}'", (Object)token));
        }
        return NullValue.NULL;
    }

    private void unread() {
        if (this._offset > 0) {
            --this._offset;
        }
    }

    private int peek(int index) {
        if (0 <= index && index < this._len) {
            return this._string.charAt(index);
        }
        return -1;
    }

    private int read() {
        if (this._offset < this._len) {
            return this._string.charAt(this._offset++);
        }
        return -1;
    }

    private int skipWhitespace() {
        int ch = this.read();
        while (ch >= 0 && (ch == 32 || ch == 10 || ch == 13 || ch == 9)) {
            ch = this.read();
        }
        return ch;
    }
}

