/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullThisValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.Arg;
import com.caucho.quercus.program.BlockStatement;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.FunctionInfo;
import com.caucho.quercus.program.Statement;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.logging.Logger;

public class Function
extends AbstractFunction {
    private static final Logger log = Logger.getLogger(Function.class.getName());
    private static final L10N L = new L10N(Function.class);
    protected final FunctionInfo _info;
    protected final boolean _isReturnsReference;
    protected final String _name;
    protected final Arg[] _args;
    protected final Statement _statement;
    protected boolean _isStatic = true;
    protected boolean _hasReturn;

    Function(Location location, String name, FunctionInfo info, Arg[] args, Statement[] statements) {
        super(location);
        this._name = name.intern();
        this._info = info;
        this._info.setFunction(this);
        this._isReturnsReference = info.isReturnsReference();
        this._args = args;
        this._statement = new BlockStatement(location, statements);
        this.setGlobal(info.isPageStatic());
    }

    public Function(ExprFactory exprFactory, Location location, String name, FunctionInfo info, Arg[] args, Statement[] statements) {
        super(location);
        this._name = name.intern();
        this._info = info;
        this._info.setFunction(this);
        this._isReturnsReference = info.isReturnsReference();
        this._args = new Arg[args.length];
        System.arraycopy(args, 0, this._args, 0, args.length);
        this._statement = exprFactory.createBlock(location, statements);
        this.setGlobal(info.isPageStatic());
    }

    public String getName() {
        return this._name;
    }

    public ClassDef getDeclaringClass() {
        return this._info.getDeclaringClass();
    }

    public String getDeclaringClassName() {
        ClassDef declaringClass = this._info.getDeclaringClass();
        if (declaringClass != null) {
            return declaringClass.getName();
        }
        return null;
    }

    public Arg[] getArgs() {
        return this._args;
    }

    public void setStatic(boolean isStatic) {
        this._isStatic = isStatic;
    }

    public boolean isStatic() {
        return this._isStatic;
    }

    public boolean isObjectMethod() {
        return false;
    }

    public boolean isReturnsReference() {
        return this._isReturnsReference;
    }

    public Value execute(Env env) {
        return null;
    }

    public Value[] evalArguments(Env env, Expr fun, Expr[] args) {
        Value[] values = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            Arg arg = null;
            if (i < this._args.length) {
                arg = this._args[i];
            }
            values[i] = arg == null ? args[i].eval(env).copy() : (arg.isReference() ? args[i].evalRef(env) : args[i].eval(env));
        }
        return values;
    }

    public Value call(Env env, Expr[] args) {
        return this.callImpl(env, args, false);
    }

    public Value callCopy(Env env, Expr[] args) {
        return this.callImpl(env, args, false);
    }

    public Value callRef(Env env, Expr[] args) {
        return this.callImpl(env, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value callImpl(Env env, Expr[] args, boolean isRef) {
        Arg arg;
        int i;
        HashMap<String, Var> map = new HashMap<String, Var>();
        Value[] values = new Value[args.length];
        for (i = 0; i < args.length; ++i) {
            arg = null;
            if (i < this._args.length) {
                arg = this._args[i];
            }
            if (arg == null) {
                values[i] = args[i].eval(env).copy();
                continue;
            }
            if (arg.isReference()) {
                values[i] = args[i].evalRef(env);
                map.put(arg.getName(), values[i].toRefVar());
                continue;
            }
            values[i] = args[i].eval(env);
            Var var = values[i].toVar();
            map.put(arg.getName(), var);
            values[i] = var.toValue();
        }
        for (i = args.length; i < this._args.length; ++i) {
            arg = this._args[i];
            Expr defaultExpr = arg.getDefault();
            if (defaultExpr == null) {
                return env.error("expected default expression");
            }
            if (arg.isReference()) {
                map.put(arg.getName(), defaultExpr.evalRef(env).toVar());
                continue;
            }
            map.put(arg.getName(), defaultExpr.eval(env).copy().toVar());
        }
        HashMap<String, Var> oldMap = env.pushEnv(map);
        Value[] oldArgs = env.setFunctionArgs(values);
        Value oldThis = this.isStatic() ? env.setThis(NullThisValue.NULL) : env.getThis();
        try {
            Value value = this._statement.execute(env);
            if (value == null) {
                NullValue nullValue = NullValue.NULL;
                return nullValue;
            }
            if (this._isReturnsReference && isRef) {
                Value value2 = value;
                return value2;
            }
            Value value3 = value.copyReturn();
            return value3;
        }
        finally {
            env.restoreFunctionArgs(oldArgs);
            env.popEnv(oldMap);
            env.setThis(oldThis);
        }
    }

    public Value call(Env env, Value[] args) {
        return this.callImpl(env, args, false);
    }

    public Value callCopy(Env env, Value[] args) {
        return this.callImpl(env, args, false);
    }

    public Value callRef(Env env, Value[] args) {
        return this.callImpl(env, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value callImpl(Env env, Value[] args, boolean isRef) {
        Arg arg;
        int i;
        HashMap<String, Var> map = new HashMap<String, Var>();
        for (i = 0; i < args.length; ++i) {
            arg = null;
            if (i < this._args.length) {
                arg = this._args[i];
            }
            if (arg == null) continue;
            if (arg.isReference()) {
                map.put(arg.getName(), args[i].toRefVar());
                continue;
            }
            Var var = args[i].copy().toVar();
            if (arg.getExpectedClass() != null && arg.getDefault() == null) {
                env.checkTypeHint(var, arg.getExpectedClass(), arg.getName(), this.getName());
            }
            map.put(arg.getName(), var);
        }
        for (i = args.length; i < this._args.length; ++i) {
            arg = this._args[i];
            Expr defaultExpr = arg.getDefault();
            if (defaultExpr == null) {
                return env.error("expected default expression");
            }
            if (arg.isReference()) {
                map.put(arg.getName(), defaultExpr.evalRef(env).toVar());
                continue;
            }
            map.put(arg.getName(), defaultExpr.eval(env).copy().toVar());
        }
        HashMap<String, Var> oldMap = env.pushEnv(map);
        Value[] oldArgs = env.setFunctionArgs(args);
        Value oldThis = this.isStatic() ? env.setThis(NullThisValue.NULL) : env.getThis();
        try {
            Value value = this._statement.execute(env);
            if (value == null) {
                NullValue nullValue = NullValue.NULL;
                return nullValue;
            }
            if (this._isReturnsReference && isRef) {
                Value value2 = value;
                return value2;
            }
            Value value3 = value.copyReturn();
            return value3;
        }
        finally {
            env.restoreFunctionArgs(oldArgs);
            env.popEnv(oldMap);
            env.setThis(oldThis);
        }
    }

    private boolean isVariableArgs() {
        return this._info.isVariableArgs() || this._args.length > 5;
    }

    private boolean isVariableMap() {
        return this._info.isUsesSymbolTable() || this._info.isVariableVar();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

