/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Address;
import com.kenai.jffi.Foreign;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Library {
    private static final Map<String, WeakReference<Library>> cache = new ConcurrentHashMap<String, WeakReference<Library>>();
    private static final Object lock = new Object();
    private static final ThreadLocal<String> lastError = new ThreadLocal();
    public static final int LAZY = 1;
    public static final int NOW = 2;
    public static final int LOCAL = 4;
    public static final int GLOBAL = 8;
    private final long handle;
    private final String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long dlopen(String name2, int flags) {
        Foreign foreign = Foreign.getInstance();
        Object object = lock;
        synchronized (object) {
            long address2 = foreign.dlopen(name2, flags);
            if (address2 == 0L) {
                lastError.set(foreign.dlerror());
            }
            return address2;
        }
    }

    public static final Library getDefault() {
        return DefaultLibrary.INSTANCE;
    }

    public static final Library getCachedInstance(String name2, int flags) {
        Library lib;
        if (name2 == null) {
            return Library.getDefault();
        }
        WeakReference<Library> ref = cache.get(name2);
        if (ref != null && (lib = (Library)ref.get()) != null) {
            return lib;
        }
        long address2 = Library.dlopen(name2, flags);
        if (address2 == 0L) {
            return null;
        }
        lib = new Library(name2, address2);
        cache.put(name2, new WeakReference<Library>(lib));
        return lib;
    }

    public static final Library openLibrary(String name2, int flags) {
        long address2 = Library.dlopen(name2, flags);
        return address2 != 0L ? new Library(name2, address2) : null;
    }

    private Library(String name2, long address2) {
        this.name = name2;
        this.handle = address2;
    }

    @Deprecated
    public Library(String name2, int flags) {
        this.name = name2;
        this.handle = Library.dlopen(name2, flags);
        if (this.handle == 0L) {
            String error = String.format("Could not open [%s]: %s", name2, Library.getLastError());
            throw new UnsatisfiedLinkError(error);
        }
    }

    @Deprecated
    public final Address findSymbol(String name2) {
        return new Address(this.getSymbolAddress(name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSymbolAddress(String name2) {
        Foreign foreign = Foreign.getInstance();
        Object object = lock;
        synchronized (object) {
            long address2 = foreign.dlsym(this.handle, name2);
            if (address2 == 0L) {
                lastError.set(foreign.dlerror());
            }
            return address2;
        }
    }

    @Deprecated
    public static final String lastError() {
        return Library.getLastError();
    }

    public static final String getLastError() {
        String error = lastError.get();
        return error != null ? error : "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.handle != 0L) {
                Foreign.getInstance().dlclose(this.handle);
            }
        }
        finally {
            super.finalize();
        }
    }

    private static final class DefaultLibrary {
        private static final Library INSTANCE = new Library(null, 1);

        private DefaultLibrary() {
        }
    }
}

