/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Library;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.jruby.ext.ffi.Factory;

public class FileDescriptorByteChannel
implements ByteChannel {
    private static final LibC libc = Factory.getInstance().loadLibrary("c", LibC.class);
    private final int fd;
    private volatile boolean isOpen = true;

    public FileDescriptorByteChannel(int fd) {
        this.fd = fd;
    }

    public int read(ByteBuffer dst) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Not open");
        }
        int n = libc.read(this.fd, dst, dst.remaining());
        if (n > 0) {
            dst.position(dst.position() + n);
        }
        return n;
    }

    public int write(ByteBuffer src) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Not open");
        }
        int n = libc.write(this.fd, src, src.remaining());
        if (n > 0) {
            src.position(src.position() + n);
        }
        return n;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() throws IOException {
        if (!this.isOpen) {
            throw new IllegalStateException("file already closed");
        }
        this.isOpen = false;
        libc.close(this.fd);
    }

    private static interface LibC
    extends Library {
        public int read(int var1, ByteBuffer var2, int var3);

        public int write(int var1, ByteBuffer var2, int var3);

        public int close(int var1);
    }
}

