/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.ConfigException;
import com.caucho.config.LineException;
import com.caucho.util.DisplayableException;
import com.caucho.util.LineCompileException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class LineConfigException
extends ConfigException
implements LineCompileException,
LineException {
    private String _filename;
    private int _line = -1;

    public LineConfigException() {
    }

    public LineConfigException(String msg) {
        super(msg);
    }

    public LineConfigException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public LineConfigException(String filename, int line, String message) {
        super(filename + ":" + line + ": " + message);
        this._filename = filename;
        this._line = line;
    }

    public LineConfigException(String filename, int line, Throwable cause) {
        super(filename + ":" + line + ": " + cause.getMessage(), cause);
        this._filename = filename;
        this._line = line;
    }

    public LineConfigException(String filename, int line, String message, Throwable cause) {
        super(filename + ":" + line + ": " + message, cause);
        this._filename = filename;
        this._line = line;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLineNumber() {
        return this._line;
    }

    public String toString() {
        return this.getMessage();
    }

    public static RuntimeException create(String filename, int line, Throwable e) {
        String loc = filename + ": " + line + ": ";
        if (e instanceof LineException) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return new LineConfigException(filename, line, e.getMessage(), e);
        }
        if (e instanceof DisplayableException) {
            return new LineConfigException(filename, line, e.getMessage(), e);
        }
        return new LineConfigException(filename, line, e.toString(), e);
    }

    public static RuntimeException create(Field field, Throwable e) {
        return LineConfigException.create(LineConfigException.loc(field), e);
    }

    public static RuntimeException create(Method method, Throwable e) {
        return LineConfigException.create(LineConfigException.loc(method), e);
    }

    public static RuntimeException create(String loc, Throwable e) {
        if (e instanceof LineException) {
            if (e instanceof RuntimeException) {
                return (RuntimeException)e;
            }
            return new LineConfigException(e.getMessage(), e);
        }
        if (e instanceof DisplayableException) {
            return new LineConfigException(loc + e.getMessage(), e);
        }
        return new LineConfigException(loc + e, e);
    }

    public static RuntimeException create(Throwable e) {
        if (e instanceof LineCompileException) {
            return new LineConfigException(e.getMessage(), e);
        }
        if (e instanceof DisplayableException) {
            return new ConfigException(e.getMessage(), e);
        }
        return new ConfigException(e.toString(), e);
    }

    public static String loc(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName() + ": ";
    }

    public static String loc(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName() + "(): ";
    }
}

