/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import com.caucho.util.ClockCacheItem;
import com.caucho.util.SyncCacheListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongKeyLruCache<V> {
    private static final Logger log = Logger.getLogger(LongKeyLruCache.class.getName());
    private static final Integer NULL = new Integer(0);
    private CacheItem<V>[] _entries;
    private int _capacity;
    private int _capacity1;
    private int _mask;
    private int _size1;
    private CacheItem<V> _head1;
    private CacheItem<V> _tail1;
    private int _size2;
    private CacheItem<V> _head2;
    private CacheItem<V> _tail2;
    private volatile long _hitCount;
    private volatile long _missCount;

    public LongKeyLruCache(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 8 * initialCapacity; capacity *= 2) {
        }
        this._entries = new CacheItem[capacity];
        this._mask = capacity - 1;
        this._capacity = initialCapacity;
        this._capacity1 = this._capacity / 2;
    }

    public int size() {
        return this._size1 + this._size2;
    }

    public int getCapacity() {
        return this._capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int newCapacity) {
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            int capacity;
            for (capacity = this._entries.length; capacity < 8 * newCapacity; capacity *= 2) {
            }
            if (capacity == this._entries.length) {
                return;
            }
            CacheItem<V>[] oldEntries = this._entries;
            this._entries = new CacheItem[capacity];
            this._mask = capacity - 1;
            this._capacity = newCapacity;
            this._capacity1 = this._capacity / 2;
            this._size2 = 0;
            this._size1 = 0;
            this._tail1 = null;
            this._head1 = null;
            this._tail2 = null;
            this._head2 = null;
            for (int i = 0; i < oldEntries.length; ++i) {
                CacheItem<V> item = oldEntries[i];
                while (item != null) {
                    this.put(item._key, item._value);
                    item = item._next;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int i;
        ArrayList<CacheListener> listeners = null;
        ArrayList<SyncCacheListener> syncListeners = null;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            for (int i2 = this._entries.length - 1; i2 >= 0; --i2) {
                CacheItem<V> item = this._entries[i2];
                while (item != null) {
                    if (item._value instanceof CacheListener) {
                        if (listeners == null) {
                            listeners = new ArrayList<CacheListener>();
                        }
                        listeners.add((CacheListener)item._value);
                    }
                    if (item._value instanceof SyncCacheListener) {
                        if (syncListeners == null) {
                            syncListeners = new ArrayList<SyncCacheListener>();
                        }
                        syncListeners.add((SyncCacheListener)item._value);
                    }
                    item = item._next;
                }
                this._entries[i2] = null;
            }
            this._size1 = 0;
            this._head1 = null;
            this._tail1 = null;
            this._size2 = 0;
            this._head2 = null;
            this._tail2 = null;
        }
        int n = i = listeners == null ? -1 : listeners.size() - 1;
        while (i >= 0) {
            CacheListener listener = (CacheListener)listeners.get(i);
            listener.removeEvent();
            --i;
        }
        int n2 = i = syncListeners == null ? -1 : syncListeners.size() - 1;
        while (i >= 0) {
            SyncCacheListener listener = (SyncCacheListener)syncListeners.get(i);
            listener.syncRemoveEvent();
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long key) {
        int hash = LongKeyLruCache.hash(key) & this._mask;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            CacheItem<V> item = this._entries[hash];
            while (item != null) {
                if (item._key == key) {
                    this.updateLru(item);
                    ++this._hitCount;
                    return item._value;
                }
                item = item._next;
            }
            ++this._missCount;
        }
        return null;
    }

    public V put(long key, V value) {
        V oldValue = this.put(key, value, true);
        if (oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    public V putIfNew(long key, V value) {
        V oldValue = this.put(key, value, false);
        if (oldValue != null) {
            return oldValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V put(long key, V value, boolean replace) {
        for (int max = 32; max > 0 && this._capacity <= this._size1 + this._size2 && this.removeTail(); --max) {
        }
        int hash = LongKeyLruCache.hash(key) & this._mask;
        int count = this._size1 + this._size2 + 1;
        V oldValue = null;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            CacheItem<V> item = this._entries[hash];
            while (item != null) {
                if (item._key == key) {
                    this.updateLru(item);
                    oldValue = item._value;
                    if (!replace) break;
                    item._value = value;
                    break;
                }
                item = item._next;
            }
            if (item == null) {
                item = new CacheItem<V>(key, value);
                item._next = this._entries[hash];
                if (this._entries[hash] != null) {
                    this._entries[hash]._prev = item;
                }
                this._entries[hash] = item;
                ++this._size1;
                item._nextLru = this._head1;
                if (this._head1 != null) {
                    this._head1._prevLru = item;
                } else {
                    this._tail1 = item;
                }
                this._head1 = item;
                return null;
            }
            if (replace && oldValue instanceof SyncCacheListener) {
                ((SyncCacheListener)oldValue).syncRemoveEvent();
            }
        }
        if (replace && oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    private void updateLru(CacheItem<V> item) {
        CacheItem prevLru = item._prevLru;
        CacheItem nextLru = item._nextLru;
        if (item._isOnce) {
            item._isOnce = false;
            if (prevLru != null) {
                prevLru._nextLru = nextLru;
            } else {
                this._head1 = nextLru;
            }
            if (nextLru != null) {
                nextLru._prevLru = prevLru;
            } else {
                this._tail1 = prevLru;
            }
            item._prevLru = null;
            if (this._head2 != null) {
                this._head2._prevLru = item;
            } else {
                this._tail2 = item;
            }
            item._nextLru = this._head2;
            this._head2 = item;
            --this._size1;
            ++this._size2;
        } else {
            if (prevLru == null) {
                return;
            }
            prevLru._nextLru = nextLru;
            item._prevLru = null;
            item._nextLru = this._head2;
            this._head2._prevLru = item;
            this._head2 = item;
            if (nextLru != null) {
                nextLru._prevLru = prevLru;
            } else {
                this._tail2 = prevLru;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTail() {
        CacheItem<V> tail = this._capacity1 <= this._size1 ? this._tail1 : this._tail2;
        for (int max = 32; max > 0; --max) {
            if (tail == null) {
                return false;
            }
            Object value = tail._value;
            LongKeyLruCache longKeyLruCache = this;
            synchronized (longKeyLruCache) {
                if (value instanceof ClockCacheItem) {
                    ClockCacheItem item = (ClockCacheItem)value;
                    item.clearUsed();
                    if (item.isUsed()) {
                        tail = tail._prevLru;
                        continue;
                    }
                }
                if ((value = this.removeImpl(tail._key)) instanceof SyncCacheListener) {
                    ((SyncCacheListener)value).syncRemoveEvent();
                }
            }
            if (value instanceof CacheListener) {
                ((CacheListener)value).removeEvent();
            }
            return true;
        }
        log.fine("LRU-Cache can't remove tail because the tail values are busy.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long key) {
        V value = null;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            value = this.removeImpl(key);
            if (value instanceof SyncCacheListener) {
                ((SyncCacheListener)value).syncRemoveEvent();
            }
        }
        if (value instanceof CacheListener) {
            ((CacheListener)value).removeEvent();
        }
        return value;
    }

    private V removeImpl(long key) {
        int hash = LongKeyLruCache.hash(key) & this._mask;
        int count = this._size1 + this._size2 + 1;
        CacheItem<V> item = this._entries[hash];
        while (item != null) {
            if (item._key == key) {
                CacheItem prev = item._prev;
                CacheItem next = item._next;
                if (prev != null) {
                    prev._next = next;
                } else {
                    this._entries[hash] = next;
                }
                if (next != null) {
                    next._prev = prev;
                }
                CacheItem prevLru = item._prevLru;
                CacheItem nextLru = item._nextLru;
                if (item._isOnce) {
                    --this._size1;
                    if (prevLru != null) {
                        prevLru._nextLru = nextLru;
                    } else {
                        this._head1 = nextLru;
                    }
                    if (nextLru != null) {
                        nextLru._prevLru = prevLru;
                    } else {
                        this._tail1 = prevLru;
                    }
                } else {
                    --this._size2;
                    if (prevLru != null) {
                        prevLru._nextLru = nextLru;
                    } else {
                        this._head2 = nextLru;
                    }
                    if (nextLru != null) {
                        nextLru._prevLru = prevLru;
                    } else {
                        this._tail2 = prevLru;
                    }
                }
                return item._value;
            }
            item = item._next;
        }
        return null;
    }

    private static int hash(long key) {
        long hash = key;
        hash = 65537L * hash + (key >>> 8);
        hash = 65537L * hash + (key >>> 16);
        hash = 65537L * hash + (key >>> 32);
        hash = 65537L * hash + (key >>> 48);
        return (int)hash;
    }

    public Iterator<V> values() {
        ValueIterator iter = new ValueIterator(this);
        iter.init(this);
        return iter;
    }

    public Iterator<V> values(Iterator<V> oldIter) {
        ValueIterator iter = (ValueIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public long getHitCount() {
        return this._hitCount;
    }

    public long getMissCount() {
        return this._missCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueIterator<V>
    implements Iterator<V> {
        private LongKeyLruCache<V> _cache;
        private int _i = -1;

        ValueIterator(LongKeyLruCache<V> cache) {
            this.init(cache);
        }

        void init(LongKeyLruCache<V> cache) {
            this._cache = cache;
            this._i = -1;
        }

        @Override
        public boolean hasNext() {
            int i;
            CacheItem[] entries = ((LongKeyLruCache)this._cache)._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length; ++i) {
                if (entries[i] == null) continue;
                this._i = i - 1;
                return true;
            }
            this._i = i;
            return false;
        }

        @Override
        public V next() {
            int i;
            CacheItem[] entries = ((LongKeyLruCache)this._cache)._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length; ++i) {
                CacheItem entry = entries[i];
                if (entry == null) continue;
                this._i = i;
                return entry._value;
            }
            this._i = i;
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheItem<V> {
        CacheItem<V> _prev;
        CacheItem<V> _next;
        CacheItem<V> _prevLru;
        CacheItem<V> _nextLru;
        long _key;
        V _value;
        int _index;
        boolean _isOnce;

        CacheItem(long key, V value) {
            this._key = key;
            this._value = value;
            this._isOnce = true;
        }
    }
}

