/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class ContextLoaderObjectInputStream
extends ObjectInputStream {
    public ContextLoaderObjectInputStream(InputStream is) throws IOException {
        super(is);
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        String name = v.getName();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        return Class.forName(name, false, loader);
    }

    protected Class resolveProxyClass(String[] interfaceNames) throws IOException, ClassNotFoundException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        Class[] clArray = new Class[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            clArray[i] = Class.forName(interfaceNames[i], false, loader);
        }
        return Proxy.getProxyClass(loader, clArray);
    }
}

