/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Crc64;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

public class Crc64Stream
extends StreamImpl {
    private StreamImpl _next;
    private long _crc;

    public Crc64Stream(StreamImpl next) {
        this._next = next;
    }

    public Crc64Stream() {
    }

    public void init(StreamImpl next) {
        this._next = next;
        this._crc = 0L;
    }

    public long getCRC() {
        return this._crc;
    }

    public boolean canRead() {
        return this._next.canRead();
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int len = this._next.read(buffer, offset, length);
        this._crc = Crc64.generate(this._crc, buffer, offset, len);
        return len;
    }

    public boolean canWrite() {
        return this._next.canWrite();
    }

    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        this._crc = Crc64.generate(this._crc, buffer, offset, length);
        this._next.write(buffer, offset, length, isEnd);
    }

    public void clearWrite() {
        this._next.clearWrite();
    }

    public void flush() throws IOException {
        this._next.flush();
    }

    public void closeWrite() throws IOException {
        this._next.closeWrite();
    }

    public Path getPath() {
        return this._next.getPath();
    }

    public void setPath(Path path) {
        this._next.setPath(path);
    }

    public void close() throws IOException {
        this._next.close();
    }
}

