/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.AbstractBinaryOutput;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileOutput
extends AbstractBinaryOutput
implements LockableStream,
EnvCleanup {
    private static final Logger log = Logger.getLogger(FileOutput.class.getName());
    private Env _env;
    private Path _path;
    private WriteStream _os;
    private long _offset;

    public FileOutput(Env env, Path path) throws IOException {
        this(env, path, false);
    }

    public FileOutput(Env env, Path path, boolean isAppend) throws IOException {
        this._env = env;
        env.addCleanup(this);
        this._path = path;
        this._os = isAppend ? path.openAppend() : path.openWrite();
    }

    public OutputStream getOutputStream() {
        return this._os;
    }

    public Path getPath() {
        return this._path;
    }

    public void print(char v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    public void print(String v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    public void write(int ch) throws IOException {
        if (this._os != null) {
            this._os.write(ch);
        }
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this._os != null) {
            this._os.write(buffer, offset, length);
        }
    }

    public void flush() throws IOException {
        if (this._os != null) {
            this._os.flush();
        }
    }

    public void closeWrite() {
        this.close();
    }

    public void close() {
        this._env.removeCleanup(this);
        this.cleanup();
    }

    public void cleanup() {
        try {
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public boolean lock(boolean shared, boolean block) {
        return this._os.lock(shared, block);
    }

    public boolean unlock() {
        return this._os.unlock();
    }

    public Value stat() {
        return FileModule.statImpl(this._env, this.getPath());
    }

    public long getPosition() {
        if (this._os == null) {
            return -1L;
        }
        return this._os.getPosition();
    }

    public boolean setPosition(long offset) {
        if (this._os == null) {
            return false;
        }
        try {
            return this._os.setPosition(offset);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public String toString() {
        return "FileOutput[" + this.getPath() + "]";
    }
}

