/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.gettext;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.lib.gettext.GettextParser;
import com.caucho.quercus.lib.gettext.expr.PluralExpr;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MOFileParser
extends GettextParser {
    private static final Logger log = Logger.getLogger(MOFileParser.class.getName());
    private static final L10N L = new L10N(MOFileParser.class);
    private Env _env;
    private ReadStream _in;
    private byte[] _tmpBuf = new byte[4];
    private boolean _isLittleEndian;
    private int _numberOfStrings;
    private int _offsetOriginal;
    private int _offsetTranslation;

    MOFileParser(Env env, Path path) throws IOException {
        this._env = env;
        this.init(path);
    }

    private void init(Path path) throws IOException {
        this._in = path.openRead();
        this._isLittleEndian = true;
        int magic = this.readInt();
        if (magic == -569244523) {
            this._isLittleEndian = false;
        } else if (magic != -1794895138) {
            return;
        }
        this.readInt();
        this._numberOfStrings = this.readInt();
        this._offsetOriginal = this.readInt();
        this._offsetTranslation = this.readInt();
        if (this._numberOfStrings < 0 || this._offsetOriginal < 0 || this._offsetTranslation < 0) {
            return;
        }
        StringValue metadata = this.getMetadata();
        this._pluralExpr = PluralExpr.getPluralExpr(metadata);
        this._charset = MOFileParser.getCharset(metadata);
    }

    private StringValue getMetadata() throws IOException {
        this._in.setPosition((long)this._offsetTranslation);
        int length = this.readInt();
        this._in.setPosition((long)this.readInt());
        return this.readPluralForms(length).get(0);
    }

    @Override
    HashMap<StringValue, ArrayList<StringValue>> readTranslations() throws IOException {
        int i;
        int[] originalOffsets = new int[this._numberOfStrings];
        int[] translatedOffsets = new int[this._numberOfStrings];
        int[] translatedLengths = new int[this._numberOfStrings];
        StringValue[] originals = new StringValue[this._numberOfStrings];
        this._in.setPosition((long)this._offsetOriginal);
        for (i = 0; i < this._numberOfStrings; ++i) {
            this.readInt();
            originalOffsets[i] = this.readInt();
            if (originalOffsets[i] > 0) continue;
            return null;
        }
        this._in.setPosition((long)this._offsetTranslation);
        for (i = 0; i < this._numberOfStrings; ++i) {
            translatedLengths[i] = this.readInt();
            translatedOffsets[i] = this.readInt();
            if (translatedLengths[i] >= 0 && translatedOffsets[i] > 0) continue;
            return null;
        }
        this._in.setEncoding(this._charset);
        for (i = 0; i < this._numberOfStrings; ++i) {
            this._in.setPosition((long)originalOffsets[i]);
            originals[i] = this.readOriginalString();
        }
        HashMap<StringValue, ArrayList<StringValue>> map = new HashMap<StringValue, ArrayList<StringValue>>();
        for (int i2 = 0; i2 < this._numberOfStrings; ++i2) {
            this._in.setPosition((long)translatedOffsets[i2]);
            map.put(originals[i2], this.readPluralForms(translatedLengths[i2]));
        }
        return map;
    }

    private StringValue readOriginalString() throws IOException {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        int ch = this._in.readChar();
        while (ch > 0) {
            ((StringValue)sb).append((char)ch);
            ch = this._in.readChar();
        }
        return sb;
    }

    private ArrayList<StringValue> readPluralForms(int length) throws IOException {
        ArrayList<StringValue> list = new ArrayList<StringValue>();
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        while (length > 0) {
            int ch = this._in.readChar();
            if (ch > 0) {
                ((StringValue)sb).append((char)ch);
            } else {
                if (ch != 0) break;
                list.add(sb);
                sb = new UnicodeBuilderValue();
            }
            --length;
        }
        list.add(sb);
        return list;
    }

    private int readInt() throws IOException {
        int len = this._in.read(this._tmpBuf);
        if (len != 4) {
            return -1;
        }
        if (this._isLittleEndian) {
            return this._tmpBuf[0] & 0xFF | (this._tmpBuf[1] & 0xFF) << 8 | (this._tmpBuf[2] & 0xFF) << 16 | this._tmpBuf[3] << 24;
        }
        return this._tmpBuf[0] << 24 | (this._tmpBuf[1] & 0xFF) << 16 | (this._tmpBuf[2] & 0xFF) << 8 | this._tmpBuf[3] & 0xFF;
    }

    @Override
    void close() {
        if (this._in != null) {
            this._in.close();
        }
    }
}

