/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueMember;
import org.asteriskjava.live.InvalidPenaltyException;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.NoSuchInterfaceException;
import org.asteriskjava.live.QueueMemberState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.manager.action.QueuePauseAction;
import org.asteriskjava.manager.action.QueuePenaltyAction;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.AstUtil;

class AsteriskQueueMemberImpl
extends AbstractLiveObject
implements AsteriskQueueMember {
    private AsteriskQueue queue;
    private QueueMemberState state;
    private String location;
    private Integer penalty;
    private boolean paused;
    private Integer callsTaken;
    private Long lastCall;
    private String membership;

    AsteriskQueueMemberImpl(AsteriskServerImpl server, AsteriskQueueImpl queue, String location, QueueMemberState state, boolean paused, Integer penalty, String membership, Integer callsTaken, Long lastCall) {
        super(server);
        this.queue = queue;
        this.location = location;
        this.state = state;
        this.penalty = penalty;
        this.paused = paused;
        this.callsTaken = callsTaken;
        this.lastCall = lastCall;
        this.membership = membership;
    }

    @Override
    public AsteriskQueue getQueue() {
        return this.queue;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public QueueMemberState getState() {
        return this.state;
    }

    @Override
    public Integer getCallsTaken() {
        return this.callsTaken;
    }

    public void setCallsTaken(Integer callsTaken) {
        this.callsTaken = callsTaken;
    }

    @Override
    public Long getLastCall() {
        return this.lastCall;
    }

    public void setLastCall(Long lastCall) {
        this.lastCall = lastCall;
    }

    @Override
    @Deprecated
    public boolean getPaused() {
        return this.isPaused();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void setPaused(boolean paused) throws ManagerCommunicationException, NoSuchInterfaceException {
        this.sendPauseAction(new QueuePauseAction(this.location, this.queue.getName(), paused));
    }

    @Override
    public void setPausedAll(boolean paused) throws ManagerCommunicationException, NoSuchInterfaceException {
        this.sendPauseAction(new QueuePauseAction(this.location, paused));
    }

    private void sendPauseAction(QueuePauseAction action) throws ManagerCommunicationException, NoSuchInterfaceException {
        ManagerResponse response = this.server.sendAction(action);
        if (response instanceof ManagerError) {
            if (action.getQueue() != null) {
                throw new NoSuchInterfaceException("Unable to change paused state for '" + action.getInterface() + "' on '" + action.getQueue() + "': " + response.getMessage());
            }
            throw new NoSuchInterfaceException("Unable to change paused state for '" + action.getInterface() + "' on all queues: " + response.getMessage());
        }
    }

    @Override
    public String getMembership() {
        return this.membership;
    }

    @Override
    public boolean isStatic() {
        return "static".equals(this.membership);
    }

    @Override
    public boolean isDynamic() {
        return "dynamic".equals(this.membership);
    }

    @Override
    public Integer getPenalty() {
        return this.penalty;
    }

    @Override
    public void setPenalty(int penalty) throws IllegalArgumentException, ManagerCommunicationException, InvalidPenaltyException {
        if (penalty < 0) {
            throw new IllegalArgumentException("Penalty must not be negative");
        }
        ManagerResponse response = this.server.sendAction(new QueuePenaltyAction(this.location, penalty, this.queue.getName()));
        if (response instanceof ManagerError) {
            throw new InvalidPenaltyException("Unable to set penalty for '" + this.location + "' on '" + this.queue.getName() + "': " + response.getMessage());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AsteriskQueueMember[");
        sb.append("location='").append(this.location).append("'");
        sb.append("state='").append((Object)this.state).append("'");
        sb.append("paused='").append(this.paused).append("'");
        sb.append("membership='").append(this.membership).append("'");
        sb.append("queue='").append(this.queue.getName()).append("'");
        sb.append("callsTaken='").append(this.getCallsTaken()).append("'");
        sb.append("lastCall='").append(this.getLastCall()).append("'");
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }

    synchronized boolean stateChanged(QueueMemberState state) {
        if (!AstUtil.isEqual((Object)this.state, (Object)state)) {
            QueueMemberState oldState = this.state;
            this.state = state;
            this.firePropertyChange("state", (Object)oldState, (Object)state);
            return true;
        }
        return false;
    }

    synchronized boolean penaltyChanged(Integer penalty) {
        if (!AstUtil.isEqual(this.penalty, penalty)) {
            Integer oldPenalty = this.penalty;
            this.penalty = penalty;
            this.firePropertyChange("penalty", oldPenalty, penalty);
            return true;
        }
        return false;
    }

    synchronized boolean pausedChanged(boolean paused) {
        if (!AstUtil.isEqual(this.paused, paused)) {
            boolean oldPaused = this.paused;
            this.paused = paused;
            this.firePropertyChange("paused", oldPaused, paused);
            return true;
        }
        return false;
    }

    synchronized boolean callsTakenChanged(Integer callsTaken) {
        if (!AstUtil.isEqual(this.callsTaken, callsTaken)) {
            Integer oldcallsTaken = this.callsTaken;
            this.callsTaken = callsTaken;
            this.firePropertyChange("callsTaken", oldcallsTaken, callsTaken);
            return true;
        }
        return false;
    }

    synchronized boolean lastCallChanged(Long lastCall) {
        if (!AstUtil.isEqual(this.lastCall, lastCall)) {
            Long oldlastCall = this.lastCall;
            this.lastCall = lastCall;
            this.firePropertyChange("lastCall", oldlastCall, lastCall);
            return true;
        }
        return false;
    }
}

