/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.activity;

import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallDirection;
import org.asteriskjava.pbx.CallImpl;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.activities.BlindTransferActivity;
import org.asteriskjava.pbx.agi.AgiChannelActivityBlindTransfer;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.DialEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.HangupEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.internal.activity.ActivityHelper;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class BlindTransferActivityImpl
extends ActivityHelper<BlindTransferActivity>
implements BlindTransferActivity {
    private static final Log logger = LogFactory.getLog(BlindTransferActivityImpl.class);
    private final Call _call;
    private Call.OperandChannel _channelToTransfer;
    private EndPoint _transferTarget;
    private CallerID _toCallerID;
    private boolean _autoAnswer;
    private CountDownLatch _latch;
    private BlindTransferActivity.CompletionCause _completionCause;
    private long _timeout;
    private Channel _transferTargetChannel;
    private CallImpl _newCall;
    private Channel dialedChannel;
    final Channel actualChannelToTransfer;

    public BlindTransferActivityImpl(Call call, Call.OperandChannel channelToTransfer, EndPoint transferTarget, CallerID toCallerID, boolean autoAnswer, long timeout, ActivityCallback<BlindTransferActivity> listener) {
        super("BlindTransferActivity", listener);
        this._call = Objects.requireNonNull(call);
        this._channelToTransfer = channelToTransfer;
        this._transferTarget = transferTarget;
        this._toCallerID = toCallerID;
        this._autoAnswer = autoAnswer;
        this._timeout = timeout;
        this.actualChannelToTransfer = this._call.getOperandChannel(this._channelToTransfer);
        this.startActivity(true);
    }

    public BlindTransferActivityImpl(Channel agentChannel, EndPoint transferTarget, CallerID toCallerID, boolean autoAnswer, int timeout, ActivityCallback<BlindTransferActivity> iCallback) throws PBXException {
        super("BlindTransferActivity", iCallback);
        this._transferTarget = transferTarget;
        this._toCallerID = toCallerID;
        this._autoAnswer = autoAnswer;
        this._timeout = timeout;
        this.actualChannelToTransfer = agentChannel;
        this._channelToTransfer = Call.OperandChannel.ORIGINATING_PARTY;
        this._call = new CallImpl(agentChannel, CallDirection.OUTBOUND);
        this.startActivity(true);
    }

    @Override
    public boolean doActivity() throws PBXException {
        boolean success = false;
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        try {
            logger.debug("*******************************************************************************");
            logger.info("***********                    begin blind transfer            ****************");
            logger.info("***********          " + (Object)((Object)this._channelToTransfer) + "                           ****************");
            logger.debug("***********            " + this._transferTarget + "                            ****************");
            logger.debug("***********            " + this._toCallerID + "                            ****************");
            logger.debug("*******************************************************************************");
            if (!pbx.moveChannelToAgi(this.actualChannelToTransfer)) {
                throw new PBXException("Channel: " + (Object)((Object)this._channelToTransfer) + " couldn't be moved to agi");
            }
            if (!pbx.waitForChannelToQuiescent(this.actualChannelToTransfer, 3000)) {
                throw new PBXException("Channel: " + (Object)((Object)this._channelToTransfer) + " cannot be transfered as it is still in transition.");
            }
            String sipHeader = null;
            if (this._autoAnswer) {
                sipHeader = PBXFactory.getActiveProfile().getAutoAnswer();
            }
            this.actualChannelToTransfer.setCurrentActivityAction(new AgiChannelActivityBlindTransfer(this._transferTarget.getFullyQualifiedName(), sipHeader, this._toCallerID.getNumber()));
            this._latch = new CountDownLatch(1);
            success = this._latch.await(this._timeout, TimeUnit.SECONDS);
            if (!success) {
                this._completionCause = BlindTransferActivity.CompletionCause.TIMEOUT;
            } else if (this._completionCause == BlindTransferActivity.CompletionCause.CANCELLED) {
                logger.warn("Cancelled, hanging up dialed channel");
                pbx.hangup(this.dialedChannel);
            } else {
                Call call = ((CallImpl)this._call).split(this.actualChannelToTransfer);
                CallImpl rhsCall = new CallImpl(this._transferTargetChannel, CallDirection.OUTBOUND);
                try {
                    this._newCall = ((CallImpl)call).join(Call.OperandChannel.ORIGINATING_PARTY, rhsCall, Call.OperandChannel.ORIGINATING_PARTY, CallDirection.OUTBOUND);
                }
                catch (Exception e) {
                    logger.error("New call doesn't seem to exist!?");
                }
            }
        }
        catch (Exception e) {
            logger.error("error occurred in blindtransfer", e);
            this.setLastException(new PBXException(e));
        }
        return this._completionCause == BlindTransferActivity.CompletionCause.BRIDGED;
    }

    @Override
    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(BridgeEvent.class);
        required.add(LinkEvent.class);
        required.add(UnlinkEvent.class);
        required.add(HangupEvent.class);
        required.add(DialEvent.class);
        return required;
    }

    @Override
    public synchronized void onManagerEvent(ManagerEvent event) {
        DialEvent dialEvent;
        if (event instanceof BridgeEvent) {
            BridgeEvent bridge = (BridgeEvent)event;
            if (bridge.isLink()) {
                if (bridge.getChannel1().isSame(this._call.getOperandChannel(this._channelToTransfer))) {
                    this._completionCause = BlindTransferActivity.CompletionCause.BRIDGED;
                    this._transferTargetChannel = bridge.getChannel2();
                    this._latch.countDown();
                } else if (bridge.getChannel2().isSame(this._call.getOperandChannel(this._channelToTransfer))) {
                    this._completionCause = BlindTransferActivity.CompletionCause.BRIDGED;
                    this._transferTargetChannel = bridge.getChannel1();
                    this._latch.countDown();
                }
            }
        } else if (event instanceof HangupEvent) {
            HangupEvent hangup = (HangupEvent)event;
            if (hangup.getChannel().isSame(this._call.getOperandChannel(this._channelToTransfer))) {
                this._completionCause = BlindTransferActivity.CompletionCause.HANGUP;
                this._latch.countDown();
            }
            if (hangup.getChannel().isSame(this.dialedChannel)) {
                this._completionCause = BlindTransferActivity.CompletionCause.HANGUP;
                this._latch.countDown();
            }
        } else if (event instanceof DialEvent && (dialEvent = (DialEvent)event).getChannel() != null) {
            Channel operandChannel = this._call.getOperandChannel(this._channelToTransfer);
            if (dialEvent.getChannel().isSame(operandChannel)) {
                DialEvent de = (DialEvent)event;
                this.dialedChannel = de.getDestination();
            }
        }
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    @Override
    public BlindTransferActivity.CompletionCause getCompletionCause() {
        return this._completionCause;
    }

    @Override
    public void cancel() {
        this._completionCause = BlindTransferActivity.CompletionCause.CANCELLED;
        this._latch.countDown();
    }

    @Override
    public Channel getChannelToTransfer() {
        return this._call.getOperandChannel(this._channelToTransfer);
    }

    @Override
    public CallerID getTransferTargetCallerID() {
        return this._toCallerID;
    }

    @Override
    public EndPoint getTransferTarget() {
        return this._transferTarget;
    }

    @Override
    public Channel getTransferTargetChannel() {
        return this._transferTargetChannel;
    }

    @Override
    public Call getNewCall() throws PBXException {
        return this._newCall;
    }
}

