/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import java.lang.ref.PhantomReference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ClassLoaderForClassArtifacts;
import org.codehaus.groovy.reflection.stdclasses.ArrayCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BigDecimalCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BigIntegerCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BooleanCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ByteCachedClass;
import org.codehaus.groovy.reflection.stdclasses.CachedClosureClass;
import org.codehaus.groovy.reflection.stdclasses.CharacterCachedClass;
import org.codehaus.groovy.reflection.stdclasses.DoubleCachedClass;
import org.codehaus.groovy.reflection.stdclasses.FloatCachedClass;
import org.codehaus.groovy.reflection.stdclasses.IntegerCachedClass;
import org.codehaus.groovy.reflection.stdclasses.LongCachedClass;
import org.codehaus.groovy.reflection.stdclasses.NumberCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ObjectCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ShortCachedClass;
import org.codehaus.groovy.reflection.stdclasses.StringCachedClass;
import org.codehaus.groovy.util.LazyReference;
import org.codehaus.groovy.util.LockableObject;
import org.codehaus.groovy.util.ManagedConcurrentMap;
import org.codehaus.groovy.util.ManagedReference;
import org.codehaus.groovy.util.ReferenceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
extends ManagedConcurrentMap.Entry<Class, ClassInfo> {
    private static final HashSet<ClassInfo> modifiedExpandos = new HashSet();
    private final LazyCachedClassRef cachedClassRef;
    private final LazyClassLoaderRef artifactClassLoader;
    private final LockableObject lock = new LockableObject();
    public final int hash;
    private volatile int version;
    private MetaClass strongMetaClass;
    private ManagedReference<MetaClass> weakMetaClass;
    MetaMethod[] dgmMetaMethods = CachedClass.EMPTY;
    MetaMethod[] newMetaMethods = CachedClass.EMPTY;
    private ManagedConcurrentMap perInstanceMetaClassMap;
    private static ReferenceBundle softBundle = ReferenceBundle.getSoftBundle();
    private static ReferenceBundle weakBundle = ReferenceBundle.getWeakBundle();
    private static final ClassInfoSet globalClassSet = new ClassInfoSet(softBundle);
    private static final WeakReference<ThreadLocalMapHandler> localMapRef;

    ClassInfo(ManagedConcurrentMap.Segment segment, Class klazz, int hash) {
        super(softBundle, segment, klazz, hash);
        this.hash = hash;
        this.cachedClassRef = new LazyCachedClassRef(softBundle, this);
        this.artifactClassLoader = new LazyClassLoaderRef(softBundle, this);
    }

    public int getVersion() {
        return this.version;
    }

    public void incVersion() {
        ++this.version;
    }

    public ExpandoMetaClass getModifiedExpando() {
        return this.strongMetaClass == null ? null : (this.strongMetaClass instanceof ExpandoMetaClass ? (ExpandoMetaClass)this.strongMetaClass : null);
    }

    public static void clearModifiedExpandos() {
        Iterator<ClassInfo> it = modifiedExpandos.iterator();
        while (it.hasNext()) {
            ClassInfo info = it.next();
            it.remove();
            info.setStrongMetaClass(null);
        }
    }

    public CachedClass getCachedClass() {
        return (CachedClass)this.cachedClassRef.get();
    }

    public ClassLoaderForClassArtifacts getArtifactClassLoader() {
        return (ClassLoaderForClassArtifacts)this.artifactClassLoader.get();
    }

    public static ClassInfo getClassInfo(Class cls) {
        ThreadLocalMapHandler handler = (ThreadLocalMapHandler)localMapRef.get();
        Object ref = null;
        if (handler != null) {
            ref = handler.get();
        }
        LocalMap map = null;
        if (ref != null) {
            map = (LocalMap)((SoftReference)ref).get();
        }
        if (map != null) {
            return map.get(cls);
        }
        return (ClassInfo)globalClassSet.getOrPut(cls, null);
    }

    public MetaClass getStrongMetaClass() {
        return this.strongMetaClass;
    }

    public void setStrongMetaClass(MetaClass answer) {
        ++this.version;
        if (this.strongMetaClass instanceof ExpandoMetaClass) {
            ((ExpandoMetaClass)this.strongMetaClass).inRegistry = false;
            modifiedExpandos.remove(this);
        }
        this.strongMetaClass = answer;
        if (this.strongMetaClass instanceof ExpandoMetaClass) {
            ((ExpandoMetaClass)this.strongMetaClass).inRegistry = true;
            modifiedExpandos.add(this);
        }
        this.weakMetaClass = null;
    }

    public MetaClass getWeakMetaClass() {
        return this.weakMetaClass == null ? null : this.weakMetaClass.get();
    }

    public void setWeakMetaClass(MetaClass answer) {
        ++this.version;
        this.strongMetaClass = null;
        this.weakMetaClass = answer == null ? null : new ManagedReference<MetaClass>(softBundle, answer);
    }

    public MetaClass getMetaClassForClass() {
        return this.strongMetaClass != null ? this.strongMetaClass : (this.weakMetaClass == null ? null : this.weakMetaClass.get());
    }

    private MetaClass getMetaClassUnderLock() {
        MetaClass answer = this.getMetaClassForClass();
        if (answer != null) {
            return answer;
        }
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        answer = metaClassRegistry.getMetaClassCreationHandler().create((Class)this.get(), metaClassRegistry);
        answer.initialize();
        if (GroovySystem.isKeepJavaMetaClasses()) {
            this.setStrongMetaClass(answer);
        } else {
            this.setWeakMetaClass(answer);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MetaClass getMetaClass() {
        MetaClass answer = this.getMetaClassForClass();
        if (answer != null) {
            return answer;
        }
        this.lock();
        try {
            MetaClass metaClass = this.getMetaClassUnderLock();
            return metaClass;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaClass getMetaClass(Object obj) {
        MetaClass instanceMetaClass = this.getPerInstanceMetaClass(obj);
        if (instanceMetaClass != null) {
            return instanceMetaClass;
        }
        this.lock();
        try {
            MetaClass metaClass = this.getMetaClassUnderLock();
            return metaClass;
        }
        finally {
            this.unlock();
        }
    }

    public static int size() {
        return globalClassSet.size();
    }

    public static int fullSize() {
        return globalClassSet.fullSize();
    }

    @Override
    public void finalizeRef() {
        this.setStrongMetaClass(null);
        this.cachedClassRef.clear();
        this.artifactClassLoader.clear();
        super.finalizeRef();
    }

    private static CachedClass createCachedClass(Class klazz, ClassInfo classInfo) {
        if (klazz == Object.class) {
            return new ObjectCachedClass(classInfo);
        }
        if (klazz == String.class) {
            return new StringCachedClass(classInfo);
        }
        CachedClass cachedClass = Number.class.isAssignableFrom(klazz) || klazz.isPrimitive() ? (klazz == Number.class ? new NumberCachedClass(klazz, classInfo) : (klazz == Integer.class || klazz == Integer.TYPE ? new IntegerCachedClass(klazz, classInfo, klazz == Integer.class) : (klazz == Double.class || klazz == Double.TYPE ? new DoubleCachedClass(klazz, classInfo, klazz == Double.class) : (klazz == BigDecimal.class ? new BigDecimalCachedClass(klazz, classInfo) : (klazz == Long.class || klazz == Long.TYPE ? new LongCachedClass(klazz, classInfo, klazz == Long.class) : (klazz == Float.class || klazz == Float.TYPE ? new FloatCachedClass(klazz, classInfo, klazz == Float.class) : (klazz == Short.class || klazz == Short.TYPE ? new ShortCachedClass(klazz, classInfo, klazz == Short.class) : (klazz == Boolean.TYPE ? new BooleanCachedClass(klazz, classInfo, false) : (klazz == Character.TYPE ? new CharacterCachedClass(klazz, classInfo, false) : (klazz == BigInteger.class ? new BigIntegerCachedClass(klazz, classInfo) : (klazz == Byte.class || klazz == Byte.TYPE ? new ByteCachedClass(klazz, classInfo, klazz == Byte.class) : new CachedClass(klazz, classInfo)))))))))))) : (klazz.getName().charAt(0) == '[' ? new ArrayCachedClass(klazz, classInfo) : (klazz == Boolean.class ? new BooleanCachedClass(klazz, classInfo, true) : (klazz == Character.class ? new CharacterCachedClass(klazz, classInfo, true) : (Closure.class.isAssignableFrom(klazz) ? new CachedClosureClass(klazz, classInfo) : new CachedClass(klazz, classInfo)))));
        return cachedClass;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public MetaClass getPerInstanceMetaClass(Object obj) {
        if (this.perInstanceMetaClassMap == null) {
            return null;
        }
        return (MetaClass)this.perInstanceMetaClassMap.get(obj);
    }

    public void setPerInstanceMetaClass(Object obj, MetaClass metaClass) {
        ++this.version;
        if (metaClass != null) {
            if (this.perInstanceMetaClassMap == null) {
                this.perInstanceMetaClassMap = new ManagedConcurrentMap(ReferenceBundle.getWeakBundle());
            }
            this.perInstanceMetaClassMap.put(obj, metaClass);
        } else if (this.perInstanceMetaClassMap != null) {
            this.perInstanceMetaClassMap.remove(obj);
        }
    }

    public boolean hasPerInstanceMetaClasses() {
        return this.perInstanceMetaClassMap != null;
    }

    static {
        ThreadLocalMapHandler localMap = new ThreadLocalMapHandler();
        localMapRef = new WeakReference<ThreadLocalMapHandler>(localMap, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DebugRef
    extends ManagedReference<Class> {
        public static final boolean debug = false;
        private static final AtomicInteger count = new AtomicInteger();
        final String name;

        public DebugRef(Class klazz) {
            super(softBundle, klazz);
            this.name = klazz == null ? "<null>" : klazz.getName();
            count.incrementAndGet();
        }

        public void finalizeRef() {
            System.out.println(this.name + " unloaded " + count.decrementAndGet() + " classes kept");
            super.finalizeReference();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyClassLoaderRef
    extends LazyReference<ClassLoaderForClassArtifacts> {
        private final ClassInfo info;

        LazyClassLoaderRef(ReferenceBundle bundle, ClassInfo info) {
            super(bundle);
            this.info = info;
        }

        @Override
        public ClassLoaderForClassArtifacts initValue() {
            return new ClassLoaderForClassArtifacts((Class)this.info.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyCachedClassRef
    extends LazyReference<CachedClass> {
        private final ClassInfo info;

        LazyCachedClassRef(ReferenceBundle bundle, ClassInfo info) {
            super(bundle);
            this.info = info;
        }

        @Override
        public CachedClass initValue() {
            return ClassInfo.createCachedClass((Class)this.info.get(), this.info);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalMapHandler
    extends ThreadLocal<SoftReference<LocalMap>> {
        SoftReference<LocalMap> recentThreadMapRef;

        private ThreadLocalMapHandler() {
        }

        @Override
        protected SoftReference<LocalMap> initialValue() {
            return new SoftReference<LocalMap>(new LocalMap(), null);
        }

        @Override
        public SoftReference<LocalMap> get() {
            SoftReference ref;
            SoftReference<LocalMap> mapRef = this.recentThreadMapRef;
            LocalMap recent = null;
            if (mapRef != null) {
                recent = mapRef.get();
            }
            if (recent != null && recent.myThread.get() == Thread.currentThread()) {
                return mapRef;
            }
            this.recentThreadMapRef = ref = (SoftReference)super.get();
            return ref;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalMap
    extends HashMap<Class, ClassInfo> {
        private static final int CACHE_SIZE = 5;
        private final PhantomReference<Thread> myThread = new PhantomReference<Thread>(Thread.currentThread(), null);
        private int nextCacheEntry;
        private final ClassInfo[] cache = new ClassInfo[5];
        private static final ClassInfo NOINFO = new ClassInfo(null, null, 0);

        private LocalMap() {
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = NOINFO;
            }
        }

        public ClassInfo get(Class key) {
            ClassInfo info = this.getFromCache(key);
            if (info != null) {
                return info;
            }
            info = (ClassInfo)super.get(key);
            if (info != null) {
                return this.putToCache(info);
            }
            return this.putToCache((ClassInfo)globalClassSet.getOrPut(key, null));
        }

        private ClassInfo getFromCache(Class klazz) {
            int i = 0;
            int k = this.nextCacheEntry - 1;
            while (i < this.cache.length) {
                ClassInfo info;
                if (k < 0) {
                    k += 5;
                }
                if (klazz == (info = this.cache[k]).get()) {
                    this.nextCacheEntry = k + 1;
                    if (this.nextCacheEntry == 5) {
                        this.nextCacheEntry = 0;
                    }
                    return info;
                }
                ++i;
                --k;
            }
            return null;
        }

        private ClassInfo putToCache(ClassInfo classInfo) {
            this.cache[this.nextCacheEntry++] = classInfo;
            if (this.nextCacheEntry == 5) {
                this.nextCacheEntry = 0;
            }
            return classInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassInfoSet
    extends ManagedConcurrentMap<Class, ClassInfo> {
        public ClassInfoSet(ReferenceBundle bundle) {
            super(bundle);
        }

        @Override
        protected Segment createSegment(Object segmentInfo, int cap) {
            ReferenceBundle bundle = (ReferenceBundle)segmentInfo;
            if (bundle == null) {
                throw new IllegalArgumentException("bundle must not be null ");
            }
            return new Segment(bundle, cap);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class Segment
        extends ManagedConcurrentMap.Segment<Class, ClassInfo> {
            Segment(ReferenceBundle bundle, int initialCapacity) {
                super(bundle, initialCapacity);
            }

            protected ClassInfo createEntry(Class key, int hash, ClassInfo unused) {
                return new ClassInfo(this, key, hash);
            }
        }
    }
}

