/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.agi;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.RedirectAction;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AgiChannelActivityMeetme
implements AgiChannelActivityAction {
    private final Log logger = LogFactory.getLog(this.getClass());
    CountDownLatch latch = new CountDownLatch(1);
    private String room;
    private volatile boolean hangup = true;
    private Channel ichannel;
    private String bridgeProfile;
    private String userProfile;

    public AgiChannelActivityMeetme(String room, String bridgeProfile, String userProfile) {
        this.room = room;
        this.bridgeProfile = bridgeProfile;
        this.userProfile = userProfile;
    }

    @Override
    public void execute(AgiChannel channel, Channel ichannel) throws AgiException, InterruptedException {
        if (ichannel == null) {
            throw new NullPointerException("ichannel cannot be null");
        }
        this.ichannel = ichannel;
        channel.confbridge(this.room, this.bridgeProfile + "," + this.userProfile);
        if (this.hangup) {
            try {
                channel.hangup();
            }
            catch (Exception e) {
                this.logger.warn(e);
            }
        }
        this.logger.info(ichannel + " left the meetme");
    }

    @Override
    public boolean isDisconnect() {
        return false;
    }

    @Override
    public void cancel() {
        this.hangup = false;
        AsteriskSettings profile = PBXFactory.getActiveProfile();
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        RedirectAction redirect = new RedirectAction(this.ichannel, profile.getManagementContext(), pbx.getExtensionAgi(), 1);
        try {
            pbx.sendAction(redirect, 1000);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | TimeoutException e) {
            this.logger.error(e, e);
        }
    }
}

