/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusDieException;
import com.caucho.quercus.QuercusErrorException;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.QuercusLineRuntimeException;
import com.caucho.quercus.QuercusRequestAdapter;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusValueException;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.util.L10N;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import com.caucho.vfs.WriterStreamImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QuercusServletImpl {
    private static final L10N L = new L10N(QuercusServletImpl.class);
    private static final Logger log = Logger.getLogger(QuercusServletImpl.class.getName());
    protected Quercus _quercus;
    protected ServletConfig _config;
    protected ServletContext _servletContext;

    public void init(ServletConfig config) throws ServletException {
        this._config = config;
        this._servletContext = config.getServletContext();
        this.checkServletAPIVersion();
        this.getQuercus().setPwd((Path)new FilePath(this._servletContext.getRealPath("/")));
        this.getQuercus().init();
    }

    protected void checkServletAPIVersion() {
        int major = this._servletContext.getMajorVersion();
        int minor = this._servletContext.getMinorVersion();
        if (major < 2 || major == 2 && minor < 4) {
            throw new QuercusRuntimeException(L.l("Quercus requires Servlet API 2.4+."));
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Env env = null;
        WriteStream ws = null;
        try {
            VfsStream out;
            QuercusPage page;
            Path path = this.getPath(request);
            try {
                page = this.getQuercus().parse(path);
            }
            catch (FileNotFoundException ex) {
                log.log(Level.FINER, ex.toString(), ex);
                response.sendError(404);
                return;
            }
            try {
                out = new VfsStream(null, (OutputStream)response.getOutputStream());
            }
            catch (IllegalStateException e) {
                WriterStreamImpl writer = new WriterStreamImpl();
                writer.setWriter((Writer)response.getWriter());
                out = writer;
            }
            ws = new WriteStream((StreamImpl)out);
            ws.setNewlineString("\n");
            Quercus quercus = this.getQuercus();
            quercus.setServletContext(this._servletContext);
            env = quercus.createEnv(page, ws, request, response);
            try {
                env.start();
                env.setGlobalValue("request", env.wrapJava(request));
                env.setGlobalValue("response", env.wrapJava(response));
                env.setGlobalValue("servletContext", env.wrapJava(this._servletContext));
                String prepend = env.getIniString("auto_prepend_file");
                if (prepend != null) {
                    Path prependPath = env.lookup(env.createString(prepend));
                    if (prependPath == null) {
                        env.error(L.l("auto_prepend_file '{0}' not found.", (Object)prepend));
                    } else {
                        QuercusPage prependPage = this.getQuercus().parse(prependPath);
                        prependPage.executeTop(env);
                    }
                }
                page.executeTop(env);
                String append = env.getIniString("auto_append_file");
                if (append != null) {
                    Path appendPath = env.lookup(env.createString(append));
                    if (appendPath == null) {
                        env.error(L.l("auto_append_file '{0}' not found.", (Object)append));
                    } else {
                        QuercusPage appendPage = this.getQuercus().parse(appendPath);
                        appendPage.executeTop(env);
                    }
                }
            }
            catch (QuercusExitException e) {
                throw e;
            }
            catch (QuercusErrorException e) {
                throw e;
            }
            catch (QuercusLineRuntimeException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            catch (QuercusValueException e) {
                log.log(Level.FINE, e.toString(), e);
                ws.println(e.toString());
            }
            catch (Throwable e) {
                if (response.isCommitted()) {
                    e.printStackTrace(ws.getPrintWriter());
                }
                ws = null;
                throw e;
            }
            finally {
                if (env != null) {
                    env.close();
                }
                if (ws != null) {
                    ws.close();
                }
            }
        }
        catch (QuercusDieException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (QuercusExitException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (QuercusErrorException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    Path getPath(HttpServletRequest req) {
        String scriptPath = QuercusRequestAdapter.getPageServletPath(req);
        String pathInfo = QuercusRequestAdapter.getPagePathInfo(req);
        FilePath pwd = new FilePath(System.getProperty("user.dir"));
        Path path = pwd.lookup(req.getRealPath(scriptPath));
        if (path.isFile()) {
            return path;
        }
        String fullPath = pathInfo != null ? scriptPath + pathInfo : scriptPath;
        return pwd.lookup(req.getRealPath(fullPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Quercus getQuercus() {
        QuercusServletImpl quercusServletImpl = this;
        synchronized (quercusServletImpl) {
            if (this._quercus == null) {
                this._quercus = new Quercus();
            }
        }
        return this._quercus;
    }

    public void destroy() {
        this._quercus.close();
    }
}

