/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallDirection;
import org.asteriskjava.pbx.CallHangupListener;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ChannelHangupListener;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.activities.BlindTransferActivity;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class CallImpl
implements ChannelHangupListener,
Call {
    private static final Log logger = LogFactory.getLog(CallImpl.class);
    private static final AtomicInteger global_call_identifier_index = new AtomicInteger();
    private final int _uniquecallID;
    private Channel _originatingParty;
    private Channel _acceptingParty;
    private Channel _transferTargetParty;
    private final CallDirection _direction;
    private CallerID _originatingPartyCallerID = null;
    private CallerID _acceptingPartyCallerID = null;
    private EndPoint _transferTarget = null;
    private TransferType transferType = TransferType.NONE;
    private CallerID _transferTargetCallerID = null;
    private Date _callStarted;
    private Date _holdStarted = null;
    private EndPoint _parkingLot = null;
    private Date _timeAtDialin = null;
    private boolean _parked = false;
    private Integer _contactId;
    private ArrayList<CallHangupListener> _hangupListeners = new ArrayList();
    private OWNER _owner;
    protected BlindTransferActivity _transferActivity;

    public CallImpl(Channel originatingChannel, CallDirection direction) throws PBXException {
        logger.debug("Created call=" + originatingChannel + " direction=" + (Object)((Object)direction));
        this._owner = OWNER.SELF;
        this._uniquecallID = global_call_identifier_index.incrementAndGet();
        this._direction = direction;
        this._callStarted = new Date();
        this.setOriginatingParty(originatingChannel);
    }

    public CallImpl(Channel originatingChannel, Channel acceptingChannel, CallDirection direction) throws PBXException {
        logger.debug("Created call=" + originatingChannel + " direction=" + (Object)((Object)direction));
        this._owner = OWNER.SELF;
        this._uniquecallID = global_call_identifier_index.incrementAndGet();
        this._direction = direction;
        this._callStarted = new Date();
        this.setOriginatingParty(originatingChannel);
        this.setAcceptingParty(acceptingChannel);
    }

    public CallImpl(Channel agent, Channel callee) throws PBXException {
        this._owner = OWNER.SELF;
        this._uniquecallID = global_call_identifier_index.incrementAndGet();
        this._direction = CallDirection.OUTBOUND;
        this._callStarted = new Date();
        this.setOriginatingParty(agent);
        this.setAcceptingParty(callee);
    }

    public CallImpl join(Call.OperandChannel originatingOperand, Call rhs, Call.OperandChannel acceptingOperand, CallDirection direction) throws PBXException {
        CallImpl joinTo = (CallImpl)rhs;
        Channel originatingParty = null;
        Channel acceptingParty = null;
        originatingParty = this.getOperandChannel(originatingOperand);
        if (originatingParty != null && originatingParty.isLive()) {
            originatingParty.removeListener(this);
        }
        if ((acceptingParty = rhs.getOperandChannel(acceptingOperand)) != null && acceptingParty.isLive()) {
            acceptingParty.removeListener((CallImpl)rhs);
        }
        if (originatingParty == null || !originatingParty.isLive() || acceptingParty == null || !acceptingParty.isLive()) {
            throw new PBXException("Call.HangupDuringJoin");
        }
        CallImpl joined = new CallImpl(originatingParty, direction);
        joined.setAcceptingParty(acceptingParty);
        joined._owner = OWNER.SELF;
        joined._callStarted = this.minDate(this._callStarted, joinTo._callStarted);
        joined._holdStarted = this.minDate(this._holdStarted, joinTo._holdStarted);
        joined._timeAtDialin = this.minDate(this._timeAtDialin, joinTo._timeAtDialin);
        logger.debug("Joined two calls lhs=" + this + ", rhs=" + joinTo);
        return joined;
    }

    private Date minDate(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        if (d1.before(d2)) {
            return d1;
        }
        return d2;
    }

    public Call split(Call.OperandChannel channelToSplit) throws PBXException {
        Channel channel = this.getOperandChannel(channelToSplit);
        channel.removeListener(this);
        CallDirection direction = CallDirection.INBOUND;
        if (this.getLocalParty() != null && this.getLocalParty().isSame(channel)) {
            direction = CallDirection.OUTBOUND;
        }
        CallImpl call = new CallImpl(channel, direction);
        call._owner = OWNER.SELF;
        switch (channelToSplit) {
            case ACCEPTING_PARTY: {
                this.setAcceptingParty(null);
                break;
            }
            case LOCAL_PARTY: {
                if (this._direction == CallDirection.INBOUND) {
                    this.setAcceptingParty(null);
                    break;
                }
                this.setOriginatingParty(null);
                break;
            }
            case ORIGINATING_PARTY: {
                this.setOriginatingParty(null);
                break;
            }
            case REMOTE_PARTY: {
                if (this._direction == CallDirection.INBOUND) {
                    this.setOriginatingParty(null);
                    break;
                }
                this.setAcceptingParty(null);
                break;
            }
            case TRANSFER_TARGET_PARTY: {
                this.setTransferTargetParty(null);
                break;
            }
        }
        return call;
    }

    public Call split(Channel channelToSplit) throws PBXException {
        channelToSplit.removeListener(this);
        CallDirection direction = CallDirection.INBOUND;
        if (this.getLocalParty() != null && this.getLocalParty().isSame(channelToSplit)) {
            direction = CallDirection.OUTBOUND;
        }
        CallImpl call = new CallImpl(channelToSplit, direction);
        call._owner = OWNER.SELF;
        if (this._acceptingParty != null && this._acceptingParty.isSame(channelToSplit)) {
            this._acceptingParty = null;
        }
        if (this._originatingParty != null && this._originatingParty.isSame(channelToSplit)) {
            this._originatingParty = null;
        }
        if (this._transferTargetParty != null && this._transferTargetParty.isSame(channelToSplit)) {
            this._transferTargetParty = null;
        }
        return call;
    }

    @Override
    public void channelHangup(Channel channel, Integer cause, String causeText) {
        try {
            if (this.isSameChannel(this._originatingParty, channel)) {
                this.setOriginatingParty(null);
                logger.debug("Removed originatingParty=" + channel + " from Call=" + this._uniquecallID + " as channel was hung up");
            } else if (this.isSameChannel(this._acceptingParty, channel)) {
                this.setAcceptingParty(null);
                logger.debug("Removed acceptingParty=" + channel + " from Call=" + this._uniquecallID + " as channel was hung up");
            } else if (this.isSameChannel(this._transferTargetParty, channel)) {
                this.setTransferTargetParty(null);
                logger.debug("Removed transferTarget=" + channel + " from Call=" + this._uniquecallID + " as channel was hung up");
            } else {
                logger.warn("Received hangup for unknown channel=" + channel.getChannelId() + " on Call=" + this._uniquecallID + " as channel was hung up");
            }
            if (!this.isLive()) {
                this.notifyCallHangupListeners();
            }
        }
        catch (PBXException e) {
            logger.error(e, e);
        }
    }

    private boolean isSameChannel(Channel lhs, Channel rhs) {
        return lhs != null && rhs != null && lhs.isSame(rhs);
    }

    private void notifyCallHangupListeners() {
        for (CallHangupListener listener : this._hangupListeners) {
            listener.callHungup(this);
        }
    }

    @Override
    public Channel getOriginatingParty() {
        return this._originatingParty;
    }

    public void callDialedOut(Channel remoteChannel, CallerID fromClid, CallerID toClid) throws PBXException {
    }

    @Override
    public Date getCallStartTime() {
        return this._callStarted;
    }

    public Integer getContactId() {
        return this._contactId;
    }

    public EndPoint getTransferTarget() {
        return this._transferTarget;
    }

    public CallerID getTransferTargetCallerID() {
        return this._transferTargetCallerID;
    }

    @Override
    public CallerID getAcceptingPartyCallerID() {
        return this._acceptingPartyCallerID;
    }

    @Override
    public CallerID getOriginatingPartyCallerID() {
        return this._originatingPartyCallerID;
    }

    @Override
    public CallerID getRemotePartyCallerID() {
        CallerID remoteCallerID = null;
        remoteCallerID = this.getDirection() == CallDirection.INBOUND ? this.getOriginatingPartyCallerID() : this.getAcceptingPartyCallerID();
        return remoteCallerID;
    }

    public Date getHoldStartTime() {
        return this._holdStarted;
    }

    public EndPoint getParkingLot() {
        return this._parkingLot;
    }

    public Date getTimeAtDialIn() {
        return this._timeAtDialin;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public String getUniqueCallID() {
        return "" + this._uniquecallID;
    }

    public boolean isCallParked() {
        return this._parked;
    }

    private void setOriginatingParty(Channel originatingParty) throws PBXException {
        this._originatingParty = originatingParty;
        if (originatingParty != null) {
            if (!this._originatingParty.canDetectHangup() && this._acceptingParty != null && !this._acceptingParty.canDetectHangup()) {
                throw new PBXException("Call.BothWithNoHangupDetection");
            }
            this._originatingParty.addHangupListener(this);
        }
    }

    private void setAcceptingParty(Channel acceptingParty) throws PBXException {
        this._acceptingParty = acceptingParty;
        if (acceptingParty != null) {
            if (!this._acceptingParty.canDetectHangup() && this._originatingParty != null && !this._originatingParty.canDetectHangup()) {
                throw new PBXException("Call.BothWithNoHangupDetection");
            }
            this._acceptingParty.addHangupListener(this);
        }
    }

    private void setTransferTargetParty(Channel transferTargetParty) {
        this._transferTargetParty = transferTargetParty;
        if (transferTargetParty != null) {
            this._transferTargetParty.addHangupListener(this);
        }
    }

    public void setContactId(Integer _contactId) {
        this._contactId = _contactId;
    }

    @Override
    public CallDirection getDirection() {
        return this._direction;
    }

    public boolean addHangupListener(CallHangupListener listener) {
        boolean callStillUp = true;
        if (this._originatingParty != null && this._originatingParty.isLive() || this._acceptingParty != null && this._acceptingParty.isLive() || this._transferTargetParty != null && this._transferTargetParty.isLive()) {
            this._hangupListeners.add(listener);
        } else {
            callStillUp = false;
        }
        return callStillUp;
    }

    public boolean isLive() {
        boolean live = false;
        if (this._originatingParty != null && this._originatingParty.isLive() || this._acceptingParty != null && this._acceptingParty.isLive() || this._transferTargetParty != null && this._transferTargetParty.isLive()) {
            live = true;
        }
        return live;
    }

    public OWNER getOwner() {
        return this._owner;
    }

    public String toString() {
        return "State: Originating Channel:" + this.getOriginatingParty() + " Direction: " + (Object)((Object)this.getDirection()) + " accepting:" + this._acceptingParty;
    }

    @Override
    public boolean contains(Channel parkChannel) {
        boolean found = false;
        if (this.isSameChannel(this._originatingParty, parkChannel)) {
            found = true;
        } else if (this.isSameChannel(this._acceptingParty, parkChannel)) {
            found = true;
        } else if (this.isSameChannel(this._transferTargetParty, parkChannel)) {
            found = true;
        }
        return found;
    }

    @Override
    public Channel getAcceptingParty() {
        return this._acceptingParty;
    }

    @Override
    public Channel getTransferTargetParty() {
        return this._transferTargetParty;
    }

    @Override
    public Channel getRemoteParty() {
        Channel remoteChannel = null;
        remoteChannel = this.getDirection() == CallDirection.INBOUND ? this.getOriginatingParty() : this.getAcceptingParty();
        if (remoteChannel == null) {
            logger.error("remoteChannel is null for {}" + (Object)((Object)this.getDirection()));
        }
        return remoteChannel;
    }

    @Override
    public Channel getLocalParty() {
        if (this.getDirection() == CallDirection.OUTBOUND) {
            return this.getOriginatingParty();
        }
        return this.getAcceptingParty();
    }

    @Override
    public boolean canSplit() {
        return this._originatingParty != null && this._acceptingParty != null && this._transferTargetParty == null;
    }

    @Override
    public Channel getOperandChannel(Call.OperandChannel operand) {
        Channel channel;
        switch (operand) {
            case ACCEPTING_PARTY: {
                channel = this._acceptingParty;
                break;
            }
            case ORIGINATING_PARTY: {
                channel = this._originatingParty;
                break;
            }
            case REMOTE_PARTY: {
                channel = this.getRemoteParty();
                break;
            }
            case TRANSFER_TARGET_PARTY: {
                channel = this._transferTargetParty;
                break;
            }
            case LOCAL_PARTY: {
                channel = this.getLocalParty();
                break;
            }
            default: {
                throw new IllegalArgumentException("An unsupported operand was passed:" + (Object)((Object)operand));
            }
        }
        if (channel == null) {
            logger.warn("failed to get channel for " + (Object)((Object)operand));
        }
        return channel;
    }

    public boolean isSame(Call rhs) {
        return this._uniquecallID == ((CallImpl)rhs)._uniquecallID;
    }

    @Override
    public List<Channel> getChannels() {
        LinkedList<Channel> channels = new LinkedList<Channel>();
        if (this._acceptingParty != null) {
            channels.add(this._acceptingParty);
        }
        if (this._originatingParty != null) {
            channels.add(this._originatingParty);
        }
        if (this._transferTargetParty != null) {
            channels.add(this._transferTargetParty);
        }
        return channels;
    }

    public static enum OWNER {
        SELF;

    }

    public static enum TransferType {
        NONE,
        ASSISTED,
        BLIND;

    }
}

